/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.util;

import com.atlassian.bitbucket.dmz.auth.OAuth2Scope;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import java.util.Set;

public class OAuth2PermissionEscalator {
    private EscalatedSecurityContext escalatedSecurityContext;

    private OAuth2PermissionEscalator(EscalatedSecurityContext escalatedSecurityContext) {
        this.escalatedSecurityContext = escalatedSecurityContext;
    }

    public static OAuth2PermissionEscalator forAnonymous(SecurityService securityService) {
        EscalatedSecurityContext escalatedSecurityContext = securityService.anonymously("Escalating permissions for anonymous 2LO REST call");
        return new OAuth2PermissionEscalator(escalatedSecurityContext);
    }

    public static OAuth2PermissionEscalator forServiceUser(ServiceUser serviceUser, SecurityService securityService) {
        EscalatedSecurityContext escalatedSecurityContext = securityService.impersonating((ApplicationUser)serviceUser, String.format("Impersonating as a service user [id= %s, name= %s] for an OAuth2 service account", serviceUser.getId(), serviceUser.getName()));
        return new OAuth2PermissionEscalator(escalatedSecurityContext);
    }

    public void applyScopes(Set<OAuth2Scope> scopes) {
        scopes.forEach(scope -> {
            this.escalatedSecurityContext = this.escalatedSecurityContext.withPermissions(scope.getAllPermissions(true));
        });
        this.escalatedSecurityContext.applyToRequest();
    }
}

