/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.content;

import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiffHunk;
import com.atlassian.bitbucket.rest.v2.api.content.RestPath;
import com.atlassian.bitbucket.rest.v2.api.property.RestPropertySupport;
import com.atlassian.bitbucket.util.MoreStreams;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonSerialize
@JsonSurrogate(value=Diff.class)
public class RestDiff
extends RestPropertySupport {
    public static final Function<Diff, RestDiff> REST_TRANSFORM = RestDiff::new;
    private static final String BINARY = "binary";
    private static final String DESTINATION = "destination";
    private static final String HUNKS = "hunks";
    private static final String LINE_COMMENTS = "lineComments";
    private static final String SOURCE = "source";
    private static final String TRUNCATED = "truncated";

    public RestDiff() {
    }

    public RestDiff(Diff diff) {
        this(RestPath.fromPath(diff.getSource()), RestPath.fromPath(diff.getDestination()), diff.isBinary(), diff.isBinary() ? null : RestDiff.transform(diff.getHunks(), RestDiffHunk.REST_TRANSFORM), null, diff.isTruncated(), diff.getProperties());
    }

    private RestDiff(RestPath source, RestPath destination, boolean isBinary, Iterable<RestDiffHunk> hunks, Iterable<RestComment> lineComments, boolean isTruncated, PropertyMap properties) {
        this.put(SOURCE, source);
        this.put(DESTINATION, destination);
        if (isBinary) {
            this.put(BINARY, true);
        } else {
            this.put(HUNKS, hunks);
            this.putIfNotEmpty(LINE_COMMENTS, lineComments);
            this.putIfNotNull(TRUNCATED, isTruncated);
            this.putProperties((Map<String, Object>)properties);
        }
    }

    public RestPath getDestination() {
        return (RestPath)this.get(DESTINATION);
    }

    @ArraySchema(schema=@Schema(implementation=RestDiffHunk.class))
    @Nonnull
    public Set<RestDiffHunk> getHunks() {
        Iterable hunks = (Iterable)this.get(HUNKS);
        if (hunks == null) {
            return Collections.emptySet();
        }
        return MoreStreams.streamIterable((Iterable)hunks).map(hunk -> {
            if (hunk instanceof RestDiffHunk) {
                return (RestDiffHunk)hunk;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @ArraySchema(schema=@Schema(implementation=RestComment.class))
    @Nonnull
    public Set<RestComment> getLineComments() {
        Iterable comments = (Iterable)this.get(LINE_COMMENTS);
        if (comments == null) {
            return Collections.emptySet();
        }
        return MoreStreams.streamIterable((Iterable)comments).map(comment -> {
            if (comment instanceof RestComment) {
                return (RestComment)comment;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public RestPath getSource() {
        return (RestPath)this.get(SOURCE);
    }

    public boolean hasHunks() {
        return this.containsKey(HUNKS);
    }

    public boolean isBinary() {
        return this.getBoolProperty(BINARY);
    }

    public boolean isTruncated() {
        return this.getBoolProperty(TRUNCATED);
    }
}

