/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.content;

import com.atlassian.bitbucket.content.DiffHunk;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiffSegment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=DiffHunk.class)
public class RestDiffHunk
extends RestMapEntity {
    public static final Function<DiffHunk, RestDiffHunk> REST_TRANSFORM = RestDiffHunk::new;
    private static final String CONTEXT = "context";
    private static final String DESTINATION_LINE = "destinationLine";
    private static final String DESTINATION_SPAN = "destinationSpan";
    private static final String SEGMENTS = "segments";
    private static final String SOURCE_LINE = "sourceLine";
    private static final String SOURCE_SPAN = "sourceSpan";
    private static final String TRUNCATED = "truncated";

    public RestDiffHunk() {
    }

    public RestDiffHunk(DiffHunk hunk) {
        this(hunk.getSourceLine(), hunk.getSourceSpan(), hunk.getDestinationLine(), hunk.getDestinationSpan(), hunk.getContext().orElse(null), RestDiffHunk.transform(hunk.getSegments(), RestDiffSegment.REST_TRANSFORM), hunk.isTruncated());
    }

    private RestDiffHunk(int sourceLine, int sourceSpan, int destinationLine, int destinationSpan, String context, List<RestDiffSegment> segments, boolean isTruncated) {
        this.putIfNotNull(CONTEXT, context);
        this.putIfNotNull(SOURCE_LINE, sourceLine);
        this.putIfNotNull(SOURCE_SPAN, sourceSpan);
        this.putIfNotNull(DESTINATION_LINE, destinationLine);
        this.putIfNotNull(DESTINATION_SPAN, destinationSpan);
        this.putIfNotEmpty(SEGMENTS, (Collection<?>)segments);
        this.putIfNotNull(TRUNCATED, isTruncated);
    }

    public String getContext() {
        return this.getStringProperty(CONTEXT);
    }

    public int getDestinationLine() {
        return this.getIntProperty(DESTINATION_LINE);
    }

    public int getDestinationSpan() {
        return this.getIntProperty(DESTINATION_SPAN);
    }

    @ArraySchema(schema=@Schema(implementation=RestDiffSegment.class))
    public List<RestDiffSegment> getSegments() {
        return (List)this.get(SEGMENTS);
    }

    public int getSourceLine() {
        return this.getIntProperty(SOURCE_LINE);
    }

    public int getSourceSpan() {
        return this.getIntProperty(SOURCE_SPAN);
    }

    public boolean isTruncated() {
        return this.getBoolProperty(TRUNCATED);
    }
}

