/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.enrich;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.google.common.io.ByteStreams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class AvatarRequestHelper {
    private static final String OPTION_AVATAR_SCHEME = "avatarScheme";
    private static final String OPTION_AVATAR_SIZE = "avatarSize";
    private static final String OPTION_AVATAR_URL_MODE = "avatarUrlMode";
    private static final String URL_MODE_ABSOLUTE = "absolute";

    private AvatarRequestHelper() {
    }

    @Nonnull
    public static Response doConditionalGet(@Nonnull Request request, @Nonnull Date lastUpdate, @Nonnull Function<Response.ResponseBuilder, Response.ResponseBuilder> okFunction) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(lastUpdate, "lastUpdate");
        Objects.requireNonNull(okFunction, "okFunction");
        Response.ResponseBuilder rb = request.evaluatePreconditions(lastUpdate);
        if (rb == null) {
            return okFunction.apply(Response.ok().lastModified(lastUpdate)).build();
        }
        return rb.build();
    }

    @Nullable
    public static AvatarRequest makeAvatarRequest(@Nonnull ContainerRequestContext requestContext, I18nService i18nService) {
        MultivaluedMap parameters = Objects.requireNonNull(requestContext, "requestContext").getUriInfo().getQueryParameters();
        OptionalInt maybeSize = AvatarRequestHelper.maybeParseInt((MultivaluedMap<String, String>)parameters, i18nService);
        if (!maybeSize.isPresent()) {
            return null;
        }
        int size = maybeSize.getAsInt();
        if (size < 1) {
            throw new BadRequestException(i18nService.getMessage("bitbucket.rest.invalidvalue.positive", new Object[]{size, OPTION_AVATAR_SIZE}));
        }
        String scheme = (String)parameters.getFirst((Object)OPTION_AVATAR_SCHEME);
        boolean secure = StringUtils.isEmpty((CharSequence)scheme) ? requestContext.getSecurityContext().isSecure() : "https".equalsIgnoreCase(scheme);
        boolean isAbsolute = URL_MODE_ABSOLUTE.equalsIgnoreCase(StringUtils.stripToNull((String)((String)parameters.getFirst((Object)OPTION_AVATAR_URL_MODE))));
        return new AvatarRequest(secure, size, isAbsolute);
    }

    @Nonnull
    public static AvatarRequest makeAvatarRequest(@Nonnull RequestManager requestManager, @Nonnull Map<String, Object> options) {
        String scheme;
        RequestContext context = Objects.requireNonNull(requestManager, "requestManager").getRequestContext();
        Object avatarSize = Objects.requireNonNull(options, "options").get(OPTION_AVATAR_SIZE);
        int size = 64;
        if (avatarSize != null) {
            if (avatarSize instanceof Number) {
                size = ((Number)avatarSize).intValue();
            } else if (avatarSize instanceof String) {
                try {
                    size = Integer.parseInt((String)avatarSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        boolean secure = (scheme = (String)options.get(OPTION_AVATAR_SCHEME)) != null ? "https".equals(scheme) : context == null || context.isSecure();
        boolean isAbsolute = URL_MODE_ABSOLUTE.equalsIgnoreCase(StringUtils.stripToNull((String)Objects.toString(options.get(OPTION_AVATAR_URL_MODE), null)));
        return new AvatarRequest(secure, size, isAbsolute);
    }

    @Nonnull
    public static Response processAvatarResponse(@Nonnull ContainerRequestContext requestContext, @Nullable CacheControl cacheControl, @Nonnull CacheableAvatarSupplier supplier) {
        Objects.requireNonNull(requestContext, "requestContext");
        Objects.requireNonNull(supplier, "supplier");
        return AvatarRequestHelper.doConditionalGet(requestContext.getRequest(), new Date(supplier.getTimestamp()), builder -> {
            String contentType = supplier.getContentType();
            if (contentType != null) {
                builder.variant(new Variant(MediaType.valueOf((String)contentType), requestContext.getLanguage(), null));
            }
            return builder.entity(outputStream -> {
                try (InputStream inputStream = supplier.open();){
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                outputStream.flush();
            }).cacheControl(cacheControl);
        });
    }

    private static OptionalInt maybeParseInt(MultivaluedMap<String, String> parameters, String key) {
        String value = String.valueOf(parameters.getFirst((Object)key));
        if (StringUtils.isBlank((CharSequence)value) || "null".equalsIgnoreCase(value) || "undefined".equalsIgnoreCase(value)) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(key, "\"" + value + "\" is not a valid value for \"" + key + "\"; the value should be numeric");
        }
    }

    private static OptionalInt maybeParseInt(MultivaluedMap<String, String> parameters, I18nService i18nService) {
        String value = String.valueOf(parameters.getFirst((Object)OPTION_AVATAR_SIZE));
        if (StringUtils.isBlank((CharSequence)value) || "null".equalsIgnoreCase(value) || "undefined".equalsIgnoreCase(value)) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(i18nService.getMessage("bitbucket.rest.invalidvalue.numeric", new Object[]{value, OPTION_AVATAR_SIZE}));
        }
    }
}

