/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.project;

import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;

@JsonSerialize
@JsonSurrogate(value=PersonalProject.class)
public class RestPersonalProject
extends RestProject
implements PersonalProject {
    private static final String OWNER = "owner";

    public RestPersonalProject() {
    }

    public RestPersonalProject(PersonalProject project) {
        this(project.getId(), project.getKey(), project.getName(), project.getDescription(), project.getOwner());
    }

    private RestPersonalProject(int id, String key, String name, String description, ApplicationUser owner) {
        super(id, key, name, description, ProjectType.PERSONAL, null);
        if (owner != null) {
            this.put(OWNER, new RestApplicationUser(owner));
        }
    }

    @Override
    public <T> T accept(@Nonnull ProjectVisitor<T> visitor) {
        return (T)visitor.visit((PersonalProject)this);
    }

    @Nonnull
    public ApplicationUser getOwner() {
        return RestApplicationUser.valueOf(this.get(OWNER));
    }
}

