/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.user.RestPerson;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=PullRequestParticipant.class)
public class RestPullRequestParticipant
extends RestMapEntity {
    public static final String APPROVED = "approved";
    public static final String LAST_REVIEWED_COMMIT = "lastReviewedCommit";
    public static final String ROLE = "role";
    public static final String STATUS = "status";
    public static final String USER = "user";
    public static final Function<PullRequestParticipant, RestPullRequestParticipant> REST_TRANSFORM = RestPullRequestParticipant::new;

    public RestPullRequestParticipant() {
    }

    public RestPullRequestParticipant(PullRequestParticipant participant) {
        this(new RestApplicationUser(participant.getUser()), participant.getLastReviewedCommit(), participant.getRole(), participant.getStatus());
    }

    public RestPullRequestParticipant(Map<String, Object> values) {
        super(values);
    }

    private RestPullRequestParticipant(RestPerson user, String lastReviewedCommit, PullRequestRole role, PullRequestParticipantStatus status) {
        this.putIfNotNull(USER, user);
        this.putIfNotNull(LAST_REVIEWED_COMMIT, lastReviewedCommit);
        this.putIfNotNull(ROLE, role);
        if (status != null) {
            this.put(APPROVED, status == PullRequestParticipantStatus.APPROVED);
            this.put(STATUS, status);
        }
    }

    @Nullable
    public static RestPullRequestParticipant valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequestParticipant) {
            return (RestPullRequestParticipant)value;
        }
        if (value instanceof Map) {
            return new RestPullRequestParticipant((Map)value);
        }
        return null;
    }

    @Schema(example="7549846524f8aed2bd1c0249993ae1bf9d3c9998")
    public String getLastReviewedCommit() {
        return this.getStringProperty(LAST_REVIEWED_COMMIT);
    }

    public PullRequestRole getRole() {
        return this.getEnumProperty(ROLE, PullRequestRole.class);
    }

    public PullRequestParticipantStatus getStatus() {
        return this.getEnumProperty(STATUS, PullRequestParticipantStatus.class);
    }

    public RestApplicationUser getUser() {
        return RestApplicationUser.valueOf(this.get(USER));
    }

    public boolean isApproved() {
        return this.getBoolProperty(APPROVED);
    }
}

