/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.repository;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRef;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=Branch.class)
public class RestBranch
extends RestRef {
    public static final Function<Branch, RestBranch> REST_TRANSFORM = RestBranch::new;
    private static final String IS_DEFAULT = "isDefault";

    public RestBranch() {
    }

    public RestBranch(Branch branch) {
        this(branch.getId(), branch.getDisplayId(), branch.getLatestCommit(), branch.getIsDefault());
    }

    private RestBranch(String id, String displayId, String latestCommit, boolean isDefault) {
        super(id, displayId, (RefType)StandardRefType.BRANCH, latestCommit);
        this.put(IS_DEFAULT, isDefault);
    }

    @Override
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Nonnull
    public String getDisplayId() {
        return this.getStringProperty("displayId");
    }

    @Override
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Nonnull
    public RefType getType() {
        return this.getEnumProperty("type", StandardRefType.class, null);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isDefault() {
        return this.getBoolProperty(IS_DEFAULT);
    }
}

