/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.util.RestRelatedLinks;
import com.atlassian.bitbucket.scope.ScopeType;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=Repository.class)
public class RestRepository
extends RestLinkedMapEntity {
    public static final Function<Repository, RestRepository> REST_TRANSFORM = RestRepository::new;
    private static final String ARCHIVED = "archived";
    private static final String DEFAULT_BRANCH = "defaultBranch";
    private static final String DESCRIPTION = "description";
    private static final String FORKABLE = "forkable";
    private static final String HIERARCHY_ID = "hierarchyId";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ORIGIN = "origin";
    private static final String PARTITION = "partition";
    private static final String PROJECT = "project";
    private static final String PUBLIC = "public";
    private static final String SCM_ID = "scmId";
    private static final String SCOPE = "scope";
    private static final String SLUG = "slug";
    private static final String STATE = "state";
    private static final String STATUS_MESSAGE = "statusMessage";

    public RestRepository() {
    }

    public RestRepository(Repository repository) {
        this(repository, true);
    }

    public RestRepository(Repository repository, boolean includeProject) {
        this(repository.getId(), repository.getSlug(), repository.getName(), repository.getDescription(), repository.getHierarchyId(), repository.getScmId(), repository.getState(), repository.getStatusMessage(), repository.isForkable(), repository.getOrigin() == null ? null : new RestRepository(repository.getOrigin(), includeProject), includeProject ? RestProject.fromProject(repository.getProject()) : null, repository.isPublic(), repository.getPartition(), repository.isArchived());
    }

    private RestRepository(int id, String slug, String name, String description, String hierarchyId, String scmId, Repository.State state, String statusMessage, Boolean forkable, RestRepository origin, RestProject project, Boolean publiclyAccessible, int partition, Boolean archived) {
        this.putIfNotNull(SLUG, slug);
        if (id > 0) {
            this.put(ID, id);
        }
        this.put(NAME, name);
        this.putIfNotNull(DESCRIPTION, description);
        this.putIfNotNull(HIERARCHY_ID, hierarchyId);
        this.putIfNotNull(SCM_ID, scmId);
        this.putIfNotNull(STATE, state);
        this.putIfNotNull(STATUS_MESSAGE, statusMessage);
        this.putIfNotNull(FORKABLE, forkable);
        this.putIfNotNull(ORIGIN, origin);
        this.putIfNotNull(PROJECT, project);
        this.putIfNotNull(PUBLIC, publiclyAccessible);
        if (partition >= 0) {
            this.put(PARTITION, partition);
        }
        this.putIfNotNull(ARCHIVED, archived);
    }

    private RestRepository(Map<String, Object> values) {
        super(values);
    }

    public static RestRepository simple(Repository repository) {
        if (repository == null) {
            return null;
        }
        RestRepository restRepo = new RestRepository();
        restRepo.put(SCOPE, ScopeType.REPOSITORY.name());
        if (repository.getId() > 0) {
            restRepo.put(ID, repository.getId());
        }
        restRepo.put(NAME, repository.getName());
        restRepo.putIfNotNull(SLUG, repository.getSlug());
        restRepo.put(FORKABLE, repository.isForkable());
        if (repository.getOrigin() != null) {
            restRepo.put(ORIGIN, repository.getOrigin().getId());
        }
        restRepo.put(PROJECT, repository.getProject().getKey());
        restRepo.put(PUBLIC, repository.isPublic());
        if (repository.isRemote()) {
            restRepo.put(PARTITION, repository.getPartition());
        }
        return restRepo;
    }

    @Nullable
    public static RestRepository valueOf(@Nullable Object value) {
        if (value instanceof RestRepository) {
            return (RestRepository)value;
        }
        if (value instanceof Map) {
            return new RestRepository((Map)value);
        }
        return null;
    }

    @Schema(example="main", accessMode=Schema.AccessMode.WRITE_ONLY)
    public String getDefaultBranch() {
        return this.getStringProperty(DEFAULT_BRANCH);
    }

    @Schema(example="My repo description", accessMode=Schema.AccessMode.READ_ONLY)
    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @Schema(example="e3c939f9ef4a7fae272e", accessMode=Schema.AccessMode.READ_ONLY)
    public String getHierarchyId() {
        return this.getStringProperty(HIERARCHY_ID);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public int getId() {
        return this.getIntProperty(ID);
    }

    @Schema(example="My repo")
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestRepository getOrigin() {
        return (RestRepository)this.get(ORIGIN);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public int getPartition() {
        return this.getIntProperty(PARTITION);
    }

    public RestProject getProject() {
        return RestProject.valueOf(this.get(PROJECT));
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestRelatedLinks getRelatedLinks() {
        return (RestRelatedLinks)this.get("links");
    }

    @Schema(example="git")
    public String getScmId() {
        return this.getStringProperty(SCM_ID);
    }

    @Schema(example="REPOSITORY", accessMode=Schema.AccessMode.READ_ONLY)
    public String getScope() {
        return this.getStringProperty(SCOPE);
    }

    @Schema(example="my-repo")
    public String getSlug() {
        return this.getStringProperty(SLUG);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public Repository.State getState() {
        return this.getEnumProperty(STATE, Repository.State.class);
    }

    @Schema(example="Available", accessMode=Schema.AccessMode.READ_ONLY)
    public String getStatusMessage() {
        return this.getStringProperty(STATUS_MESSAGE);
    }

    public boolean hasArchived() {
        return this.get(ARCHIVED) != null;
    }

    public boolean hasDefaultBranch() {
        return this.get(DEFAULT_BRANCH) != null;
    }

    public boolean hasDescription() {
        return this.containsKey(DESCRIPTION);
    }

    public boolean hasForkable() {
        return this.get(FORKABLE) != null;
    }

    public boolean hasProject() {
        return this.getProject() != null;
    }

    public boolean hasPublic() {
        return this.get(PUBLIC) != null;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isArchived() {
        return this.getBoolProperty(ARCHIVED, false);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isForkable() {
        return this.getBoolProperty(FORKABLE, true);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isPublic() {
        return this.getBoolProperty(PUBLIC, false);
    }

    private static String httpCloneUrl(String projKey, String repoSlug) {
        return "https://<baseURL>/scm/" + projKey + "/" + repoSlug + ".git";
    }

    private static String sshCloneUrl(String projKey, String repoSlug) {
        return "ssh://git@<baseURL>/" + projKey + "/" + repoSlug + ".git";
    }
}

