/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.resolver;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentService;
import com.atlassian.bitbucket.comment.NoSuchCommentException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.NumberParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.PathParam;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CommentResolver {
    private final String commentId;
    private final CommentService commentService;
    private final I18nService i18nService;
    private Comment comment;

    public CommentResolver(I18nService i18nService, CommentService commentService, @PathParam(value="commentId") String commentId) {
        this.i18nService = i18nService;
        this.commentService = commentService;
        this.commentId = commentId;
    }

    @Nonnull
    public Comment getComment() {
        return Optional.ofNullable(this.comment).orElseGet(this::getCommentOrFail);
    }

    @Nullable
    public String getCommentId() {
        return this.commentId;
    }

    private Comment getCommentOrFail() {
        return this.commentService.getComment(this.parseCommentId(this.commentId)).map(comment -> {
            this.comment = comment;
            return comment;
        }).orElseThrow(() -> new NoSuchCommentException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchcomment", new Object[]{this.commentId})));
    }

    private long parseCommentId(String commentId) {
        if (StringUtils.isBlank((CharSequence)commentId)) {
            throw new BadRequestException("commentId", this.i18nService.createKeyedMessage("bitbucket.rest.commentid.required", new Object[0]).getLocalisedMessage());
        }
        return NumberParser.parseLong(this.i18nService, "commentId", commentId);
    }
}

