/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.resolver;

import com.atlassian.bitbucket.content.DiffContentFilter;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class DiffContentFilterResolver {
    private final UriInfo uriInfo;
    private DiffContentFilter diffContentFilter;

    public DiffContentFilterResolver(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public DiffContentFilter getDiffContentFilter() {
        if (this.diffContentFilter == null) {
            MultivaluedMap queryParameters = this.uriInfo.getQueryParameters();
            String filter = StringUtils.trimToNull((String)((String)queryParameters.getFirst((Object)"filter")));
            this.diffContentFilter = filter != null ? DiffContentFilterResolver.createFilter(filter, "true".equalsIgnoreCase((String)queryParameters.getFirst((Object)"caseSensitive"))) : null;
        }
        return this.diffContentFilter;
    }

    private static DiffContentFilter createFilter(String text, final boolean caseSensitive) {
        final String filter = caseSensitive ? text : text.toLowerCase(Locale.US);
        return new DiffContentFilter(){

            public boolean apply(@Nonnull String input) {
                if (!caseSensitive) {
                    return input.toLowerCase(Locale.US).contains(filter);
                }
                return input.contains(filter);
            }
        };
    }
}

