/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.resolver;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.resolver.NumberParser;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;

public class PageRequestResolver {
    private final I18nService i18nService;
    private final String limit;
    private final String start;
    private PageRequestImpl pageRequest;

    public PageRequestResolver(@QueryParam(value="start") @DefaultValue(value="0") String start, @QueryParam(value="limit") @DefaultValue(value="25") String limit, I18nService i18nService) {
        this.start = StringUtils.isBlank((CharSequence)start) || "null".equalsIgnoreCase(start) || "undefined".equalsIgnoreCase(start) ? "0" : start;
        this.limit = StringUtils.isBlank((CharSequence)limit) || "null".equalsIgnoreCase(limit) || "undefined".equalsIgnoreCase(limit) ? "25" : limit;
        this.i18nService = i18nService;
    }

    @Nullable
    public String getLimit() {
        return this.limit;
    }

    @Nonnull
    public PageRequest getPageRequest(int maxLimit) {
        if (this.pageRequest == null) {
            this.pageRequest = new PageRequestImpl(NumberParser.parseInt(this.i18nService, "start", this.start), Math.min(NumberParser.parseInt(this.i18nService, "limit", this.limit), maxLimit));
        }
        return this.pageRequest;
    }

    @Nonnull
    public PageRequest getPageRequest() {
        return this.getPageRequest(0x100000);
    }

    public String getStart() {
        return this.start;
    }
}

