/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.resolver;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.PathParam;

public class ProjectResolver {
    private final I18nService i18nService;
    private final Project project;
    private final String projectKey;

    public ProjectResolver(I18nService i18nService, ProjectService projectService, @PathParam(value="projectKey") String projectKey) {
        this.i18nService = i18nService;
        this.project = projectService.getByKey(this.parseProjectKey(projectKey));
        this.projectKey = projectKey;
    }

    @Nonnull
    public Project getProject() {
        if (this.project == null) {
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchproject", new Object[]{this.projectKey}));
        }
        return this.project;
    }

    @Nullable
    public String getProjectKey() {
        return this.projectKey;
    }

    String parseProjectKey(String projectKey) {
        if (projectKey == null) {
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchproject", new Object[]{projectKey}));
        }
        return projectKey;
    }
}

