/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.resolver;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.NumberParser;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.PathParam;
import org.apache.commons.lang3.StringUtils;

public class PullRequestResolver {
    private final I18nService i18nService;
    private final String pullRequestId;
    private final PullRequestService pullRequestService;
    private final RepositoryResolver repositoryResolver;
    private PullRequest pullRequest;

    public PullRequestResolver(I18nService i18nService, PullRequestService pullRequestService, @BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") String pullRequestId) {
        this.i18nService = i18nService;
        this.pullRequestId = pullRequestId;
        this.pullRequestService = pullRequestService;
        this.repositoryResolver = repositoryResolver;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        if (this.pullRequest == null) {
            this.pullRequest = this.pullRequestService.getById(this.repositoryResolver.getRepository().getId(), this.parsePullRequestId(this.pullRequestId).longValue());
            if (this.pullRequest == null) {
                throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchpullrequest", new Object[]{this.pullRequestId, this.repositoryResolver.getRepository().getProject().getKey(), this.repositoryResolver.getRepository().getSlug()}));
            }
        }
        return this.pullRequest;
    }

    @Nullable
    public String getPullRequestId() {
        return this.pullRequestId;
    }

    private Long parsePullRequestId(String pullRequestId) {
        if (pullRequestId != null) {
            String pullRequestIdExtracted = StringUtils.substringBefore((String)pullRequestId, (String)".");
            try {
                return NumberParser.parseLong(this.i18nService, "pullRequestId", pullRequestIdExtracted);
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
        }
        throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchpullrequest", new Object[]{pullRequestId, this.repositoryResolver.getRepository().getProject().getKey(), this.repositoryResolver.getRepository().getSlug()}));
    }
}

