/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.resolver;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.PathParam;

public class ScopeResolver {
    private final Scope scope;

    public ScopeResolver(I18nService i18nService, ProjectService projectService, RepositoryService repositoryService, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repositorySlug) {
        if (projectKey == null) {
            this.scope = Scopes.global();
        } else if (repositorySlug != null) {
            ProjectResolver projectResolver = new ProjectResolver(i18nService, projectService, projectKey);
            RepositoryResolver repositoryResolver = new RepositoryResolver(i18nService, repositoryService, projectResolver, repositorySlug);
            this.scope = Scopes.repository((Repository)repositoryResolver.getRepository());
        } else {
            ProjectResolver projectResolver = new ProjectResolver(i18nService, projectService, projectKey);
            this.scope = Scopes.project((Project)projectResolver.getProject());
        }
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }
}

