/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.scope;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@JsonSerialize
@JsonSurrogate(value=Scope.class)
public class RestScope
extends RestMapEntity
implements Scope {
    private static final String RESOURCE_ID = "resourceId";
    private static final String TYPE = "type";

    public RestScope(@Nonnull Scope scope) {
        this.put(TYPE, Objects.requireNonNull(scope, "scope").getType().name());
        scope.getResourceId().ifPresent(id -> this.put(RESOURCE_ID, id));
    }

    public RestScope(@Nonnull OptionalInt resourceId, @Nonnull ScopeType type) {
        Objects.requireNonNull(resourceId, RESOURCE_ID);
        Objects.requireNonNull(type, TYPE);
        if (type != ScopeType.GLOBAL && !resourceId.isPresent()) {
            throw new IllegalArgumentException("Scopes of type " + String.valueOf(type) + " require a resource ID");
        }
        resourceId.ifPresent(value -> this.put(RESOURCE_ID, value));
        this.put(TYPE, type);
    }

    private RestScope(Map<String, Object> object) {
        super(object);
    }

    private RestScope(int resourceId, ScopeType type) {
        this.put(RESOURCE_ID, resourceId);
        this.put(TYPE, type);
    }

    @Nullable
    public static RestScope valueOf(@Nullable Object object) {
        if (object instanceof RestScope) {
            return (RestScope)object;
        }
        if (object instanceof Map) {
            return new RestScope((Map)object);
        }
        return null;
    }

    public <T> T accept(@Nonnull ScopeVisitor<T> visitor) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass()) + " is not intended to be visited");
    }

    @Schema(example="2")
    @Nonnull
    public Optional<Integer> getResourceId() {
        int resourceId = this.getIntProperty(RESOURCE_ID);
        return resourceId == -1 ? Optional.empty() : Optional.of(resourceId);
    }

    @Schema
    @Nonnull
    public ScopeType getType() {
        return this.getEnumProperty(TYPE, ScopeType.class);
    }
}

