/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.user;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.avatar.AvatarAware;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.user.RestDetailedUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.Person;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=Person.class)
public class RestPerson
extends RestMapEntity
implements AvatarAware,
Person {
    public static final String EMAIL_ADDRESS = "emailAddress";
    public static final String NAME = "name";
    public static final Function<Person, RestPerson> REST_TRANSFORM = person -> {
        if (person == null) {
            return null;
        }
        if (person instanceof DetailedUser) {
            return new RestDetailedUser((DetailedUser)person);
        }
        if (person instanceof ApplicationUser) {
            return new RestApplicationUser((ApplicationUser)person);
        }
        return new RestPerson((Person)person);
    };

    public RestPerson(Person author) {
        this(author.getName(), author.getEmailAddress());
    }

    protected RestPerson(String name, String emailAddress) {
        this.putIfNotNull(NAME, name);
        this.putIfNotNull(EMAIL_ADDRESS, emailAddress);
    }

    public RestPerson(Map<String, Object> map) {
        super(map);
    }

    public RestPerson() {
    }

    @Schema(example="charlie@example.com")
    @Nullable
    public String getEmailAddress() {
        return this.getStringProperty(EMAIL_ADDRESS);
    }

    @Schema(example="Charlie")
    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    public boolean hasEmailAddress() {
        return this.getStringProperty(EMAIL_ADDRESS) != null;
    }

    @Override
    public void setAvatarUrl(String avatarUrl) {
        this.put("avatarUrl", avatarUrl);
    }
}

