/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.util;

import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.CacheControl;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class CachePolicies {
    private static final Pattern COMMIT_ID_PATTERN = Pattern.compile("[0-9a-f]{40}", 2);

    public static CacheControl cacheForAMonth() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMaxAge((int)TimeUnit.DAYS.toSeconds(28L));
        cacheControl.setPrivate(true);
        return cacheControl;
    }

    public static CacheControl getCacheControlForObjectId(String objectId) {
        CacheControl cacheControl = CachePolicies.noCache();
        if (CachePolicies.isImmutableObjectId(objectId)) {
            cacheControl = CachePolicies.cacheForAMonth();
        }
        return cacheControl;
    }

    public static CacheControl getCacheControlForRange(String untilId, String sinceId) {
        CacheControl cacheControl = CachePolicies.noCache();
        if (CachePolicies.isImmutableBetween(untilId, sinceId)) {
            cacheControl = CachePolicies.cacheForAMonth();
        }
        return cacheControl;
    }

    public static CacheControl noCache() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        return cacheControl;
    }

    public static CacheControl publicCacheForAnHour() {
        CacheControl cacheForAnHour = new CacheControl();
        cacheForAnHour.setMaxAge((int)TimeUnit.HOURS.toSeconds(1L));
        cacheForAnHour.setPrivate(false);
        return cacheForAnHour;
    }

    private static boolean isImmutableBetween(@Nullable String untilId, @Nullable String sinceId) {
        return CachePolicies.isImmutableObjectId(untilId) && (sinceId == null || CachePolicies.isImmutableObjectId(sinceId));
    }

    private static boolean isImmutableObjectId(@Nullable String objectId) {
        return objectId != null && COMMIT_ID_PATTERN.matcher(objectId).matches();
    }
}

