/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.util;

import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;

public abstract class JsonStreamingOutput
implements StreamingOutput {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public void write(OutputStream output) throws IOException, WebApplicationException {
        try (StatefulJsonWriter writer = JsonStreamingOutput.createWriter(JsonStreamingOutput.wrap(output));){
            this.write(writer);
        }
    }

    public abstract void write(StatefulJsonWriter var1) throws IOException, WebApplicationException;

    private static StatefulJsonWriter createWriter(OutputStream stream) throws IOException {
        JsonGenerator generator = OBJECT_MAPPER.disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE).getFactory().createGenerator(stream, JsonEncoding.UTF8);
        return new StatefulJsonWriter(generator);
    }

    private static OutputStream wrap(OutputStream stream) {
        try {
            return new CloseShieldOutputStream(stream);
        }
        catch (NoClassDefFoundError e) {
            return stream;
        }
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }
}

