/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.util;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import java.util.OptionalInt;
import org.apache.commons.lang3.StringUtils;

public class PageHelper {
    public static final String DEFAULT_LIMIT = "25";
    public static final String DEFAULT_START = "0";
    private static final int START = Integer.parseInt("0");

    private PageHelper() {
    }

    @Nonnull
    public static PageRequest createPageRequest(@Nonnull I18nService i18nService, @Nonnull UriInfo uriInfo, int defaultLimit) {
        Objects.requireNonNull(i18nService, "i18nService");
        Objects.requireNonNull(uriInfo, "uriInfo");
        MultivaluedMap parameters = uriInfo.getQueryParameters();
        int start = PageHelper.maybeParseInt(i18nService, (MultivaluedMap<String, String>)parameters, "start").orElse(START);
        int limit = PageHelper.maybeParseInt(i18nService, (MultivaluedMap<String, String>)parameters, "limit").orElse(defaultLimit);
        return PageUtils.newRequest((int)start, (int)limit);
    }

    private static OptionalInt maybeParseInt(@Nonnull I18nService i18nService, MultivaluedMap<String, String> parameters, String key) {
        String value = (String)parameters.getFirst((Object)key);
        if (StringUtils.isBlank((CharSequence)value) || "null".equalsIgnoreCase(value) || "undefined".equalsIgnoreCase(value)) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new ArgumentValidationException(i18nService.createKeyedMessage("bitbucket.rest.invalidargument.wholenumberinteger", new Object[]{value, key}));
        }
    }
}

