/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.fragment;

import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DefaultRestFragmentContext
implements RestFragmentContext {
    private final Map<String, Object> body;
    private final String httpMethod;
    private final Map<String, List<String>> queryParameters;

    public DefaultRestFragmentContext(Map<String, Object> body, String httpMethod, UriInfo uriInfo) {
        this.body = Objects.requireNonNull(body, "body");
        this.httpMethod = Objects.requireNonNull(httpMethod, "httpMethod");
        this.queryParameters = ImmutableMap.copyOf((Map)Objects.requireNonNull(uriInfo, "uriInfo").getQueryParameters());
    }

    @Override
    @Nonnull
    public Optional<Object> getBodyProperty(@Nonnull String key) {
        return Optional.ofNullable(this.body.get(key));
    }

    @Override
    @Nonnull
    public String getMethod() {
        return this.httpMethod;
    }

    @Override
    @Nonnull
    public Optional<String> getQueryParameter(@Nonnull String name) {
        return this.getQueryParameters(name).stream().findFirst();
    }

    @Override
    @Nonnull
    public List<String> getQueryParameters(@Nonnull String name) {
        List<String> parameters = this.queryParameters.get(name);
        return parameters == null ? ImmutableList.of() : parameters;
    }

    @Override
    @Nonnull
    public Map<String, List<String>> getQueryParameters() {
        return this.queryParameters;
    }
}

