/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.plugin.internal;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.cdn.api.StaticAssetsProvider;
import com.atlassian.security.csp.api.CspDirective;
import com.atlassian.security.csp.api.CspFragment;
import com.atlassian.security.csp.api.CspModuleDescriptor;
import com.atlassian.security.csp.api.internal.ContentSecurityPolicy;
import com.atlassian.security.csp.plugin.internal.PluginSettingsProvider;
import com.atlassian.security.csp.spi.CspProvider;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.AntPathMatcher;

public class ContentSecurityPolicyHeaderFilter
implements Filter {
    @VisibleForTesting
    static final String CSP_NONCE_ID = "cspNonceId";
    private static final Pattern NONCE_PATTERN = Pattern.compile("'nonce-([a-zA-Z0-9+/=]+)'");
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final PluginAccessor pluginAccessor;
    private final PluginSettingsProvider pluginSettingsProvider;
    private final CspProvider policyProvider;
    private final StaticAssetsProvider staticAssetsProvider;

    public ContentSecurityPolicyHeaderFilter(PluginAccessor pluginAccessor, PluginSettingsProvider pluginSettingsProvider, CspProvider policyProvider, Optional<StaticAssetsProvider> staticAssetsProvider) {
        this.pluginAccessor = pluginAccessor;
        this.pluginSettingsProvider = pluginSettingsProvider;
        this.policyProvider = policyProvider;
        this.staticAssetsProvider = staticAssetsProvider.orElse(null);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ContentSecurityPolicy cspPolicy;
        ContentSecurityPolicy contentSecurityPolicy = cspPolicy = this.policyProvider == null ? null : this.policyProvider.getPolicy();
        if (cspPolicy == null || StringUtils.isBlank((CharSequence)cspPolicy.toString()) || this.pluginAccessor == null) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        List exclusionPatterns = this.policyProvider.getExclusionPatterns();
        for (String exclusionPattern : exclusionPatterns) {
            if (!this.antPathMatcher.match(exclusionPattern, httpRequest.getRequestURI())) continue;
            chain.doFilter(request, response);
            return;
        }
        this.addCdnURLToCspPolicy(httpRequest, cspPolicy);
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CspModuleDescriptor.class);
        List<CspFragment> cspFragments = descriptors.stream().map(ModuleDescriptor::getModule).toList();
        List<CspFragment> matchedCspFragments = cspFragments.stream().filter(fragment -> fragment.getUrlPatterns().stream().anyMatch(urlPattern -> this.antPathMatcher.match(urlPattern, httpRequest.getRequestURI()))).toList();
        matchedCspFragments.forEach(arg_0 -> ((ContentSecurityPolicy)cspPolicy).addCspFragment(arg_0));
        boolean strict = this.pluginSettingsProvider.isStrict();
        String cspHeaderName = this.generateHeaderName(!strict);
        String cspHeaderValue = cspPolicy.toString();
        String nonce = this.getNonce(cspHeaderValue);
        if (nonce != null && !nonce.isEmpty()) {
            request.setAttribute(CSP_NONCE_ID, (Object)nonce);
        }
        httpResponse.setHeader(cspHeaderName, cspHeaderValue);
        chain.doFilter(request, response);
    }

    private void addCdnURLToCspPolicy(final HttpServletRequest httpRequest, ContentSecurityPolicy cspPolicy) {
        final Optional<URI> cdnUrl = this.getCdnUrl();
        cspPolicy.addCspFragment(new CspFragment(){

            public Set<CspDirective> getCSPDirectives() {
                return Set.of(CspDirective.SCRIPT_SRC, CspDirective.REPORT_URI);
            }

            public Set<URI> getCSPOrigins(CspDirective directive) {
                if (CspDirective.SCRIPT_SRC.equals((Object)directive)) {
                    HashSet<URI> scriptSrcOrigins = new HashSet<URI>();
                    cdnUrl.ifPresent(scriptSrcOrigins::add);
                    return scriptSrcOrigins;
                }
                if (CspDirective.REPORT_URI.equals((Object)directive)) {
                    return Set.of(URI.create(httpRequest.getContextPath() + "/rest/csp/latest/csp-report"));
                }
                return Collections.emptySet();
            }

            public Set<String> getUrlPatterns() {
                return Collections.emptySet();
            }
        });
    }

    private String generateHeaderName(boolean reportOnly) {
        if (reportOnly) {
            return "Content-Security-Policy-Report-Only";
        }
        return "Content-Security-Policy";
    }

    private URI getCanonicalUrl(String httpRequestUrl) throws URISyntaxException {
        if (httpRequestUrl == null || httpRequestUrl.isEmpty()) {
            throw new URISyntaxException("Request URL is null or empty", "Cannot determine base URL");
        }
        URI requestURL = new URI(httpRequestUrl);
        if (requestURL.getScheme() == null || requestURL.getHost() == null) {
            throw new URISyntaxException(httpRequestUrl, "Invalid URL: Scheme or host is missing");
        }
        StringBuilder baseUrlBuilder = new StringBuilder(requestURL.getScheme());
        baseUrlBuilder.append("://");
        baseUrlBuilder.append(requestURL.getHost());
        if (requestURL.getPort() != -1 && requestURL.getPort() != 80 && requestURL.getPort() != 443) {
            baseUrlBuilder.append(":").append(requestURL.getPort());
        }
        return new URI(baseUrlBuilder.toString());
    }

    private Optional<URI> getCdnUrl() {
        if (this.staticAssetsProvider == null || !this.staticAssetsProvider.isEnabled()) {
            return Optional.empty();
        }
        try {
            String cdnUrlString = this.staticAssetsProvider.getUrl();
            if (cdnUrlString == null || cdnUrlString.isEmpty()) {
                return Optional.empty();
            }
            URI canonicalURI = this.getCanonicalUrl(cdnUrlString);
            return Optional.of(canonicalURI);
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    private String getNonce(String cspHeader) {
        try {
            Matcher matcher = NONCE_PATTERN.matcher(cspHeader);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

