/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.plugin.internal;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="pluginSettingsProvider")
public class PluginSettingsProvider {
    private static final String PLUGIN_KEY = "com.atlassian.bitbucket.server.bitbucket-content-security-policy";
    private static final String PLUGIN_SETTING_STRICT = "com.atlassian.bitbucket.server.bitbucket-content-security-policy.strict";
    private final PluginSettings pluginSettings;

    public PluginSettingsProvider(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @PostConstruct
    public void init() {
        Object strict = this.pluginSettings.get(PLUGIN_SETTING_STRICT);
        if (strict == null) {
            this.setStrict(Strictness.DEFAULT);
        }
    }

    public boolean isStrict() {
        Object strict = this.pluginSettings.get(PLUGIN_SETTING_STRICT);
        return Strictness.valueOf(strict.toString()).isStrict();
    }

    public void setStrict(@Nonnull Strictness strictness) {
        this.pluginSettings.put(PLUGIN_SETTING_STRICT, (Object)strictness.name());
    }

    public static enum Strictness {
        STRICT(true),
        REPORT_ONLY(false),
        DEFAULT(false);

        private final boolean strict;

        private Strictness(boolean strict) {
            this.strict = strict;
        }

        public boolean isStrict() {
            return this.strict;
        }
    }
}

