/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.plugin.internal.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
@Path(value="csp-report")
@Singleton
public class CspReportResource {
    private static final Logger logger = LoggerFactory.getLogger(CspReportResource.class);
    private static final int MAX_PAYLOAD_LENGTH = 2000;

    @Hidden
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    @Consumes(value={"application/json", "application/csp-report"})
    public Response logPayload(String payload) {
        logger.info(CspReportResource.sanitiseLog(payload));
        return Response.noContent().build();
    }

    private static String sanitiseLog(String payload) {
        if (((String)(payload = ((String)payload).trim())).length() > 2000) {
            payload = ((String)payload).substring(0, 2000) + "...";
        }
        payload = ((String)payload).replaceAll("[^\\p{Print}]", " ");
        return payload;
    }
}

