/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.plugin.internal.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.security.csp.plugin.internal.PluginSettingsProvider;
import com.atlassian.security.csp.plugin.internal.rest.RestCspSettings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(name="Content Security Policy")
@SystemAdminOnly
@Path(value="settings")
@Singleton
public class CspSettingsResource {
    private static final Logger logger = LoggerFactory.getLogger(CspSettingsResource.class);
    private final PluginSettingsProvider pluginSettingsProvider;

    @Inject
    public CspSettingsResource(PluginSettingsProvider pluginSettingsProvider) {
        this.pluginSettingsProvider = pluginSettingsProvider;
    }

    @Operation(description="Change the Content-Security-Policy header that is returned on all Bitbucket responses between \"Content-Security-Policy\" and \"Content-Security-Policy-Report-Only\".", summary="Change CSP strictness setting")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestCspSettings.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Setting updated", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", restError=true, responseCode=401)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    @Consumes(value={"application/json"})
    public Response settings(RestCspSettings request) {
        logger.info("Setting content security policy strictness to {}", (Object)request.getStrictness());
        this.pluginSettingsProvider.setStrict(request.getStrictness());
        return Response.noContent().build();
    }
}

