/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.filestore.s3;

import com.atlassian.bitbucket.filestore.ChecksumAlgorithm;
import com.atlassian.bitbucket.filestore.DeleteFilesRequest;
import com.atlassian.bitbucket.filestore.DeleteRecursiveRequest;
import com.atlassian.bitbucket.filestore.FileExistsRequest;
import com.atlassian.bitbucket.filestore.FilePath;
import com.atlassian.bitbucket.filestore.FileStoreConfigurationException;
import com.atlassian.bitbucket.filestore.FileStoreException;
import com.atlassian.bitbucket.filestore.GenerateGetUrlRequest;
import com.atlassian.bitbucket.filestore.GenerateGetUrlResponse;
import com.atlassian.bitbucket.filestore.GeneratePutUrlRequest;
import com.atlassian.bitbucket.filestore.GeneratePutUrlResponse;
import com.atlassian.bitbucket.filestore.PluginFileStore;
import com.atlassian.bitbucket.filestore.ReadFileRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;

public class S3PluginFileStore
implements PluginFileStore {
    public static final String PROP_ACCESS_KEY = "plugin.bitbucket-filestore-s3.access-key";
    public static final String PROP_BUCKET = "plugin.bitbucket-filestore-s3.bucket";
    public static final String PROP_ENDPOINT_OVERRIDE = "plugin.bitbucket-filestore-s3.endpoint.override";
    public static final String PROP_REGION = "plugin.bitbucket-filestore-s3.region";
    public static final String PROP_SECRET_KEY = "plugin.bitbucket-filestore-s3.secret-key";
    private static final Logger log = LoggerFactory.getLogger(S3PluginFileStore.class);
    private final String bucket;
    private final I18nService i18nService;
    private final S3Client s3Client;
    private final S3Presigner s3Presigner;

    public S3PluginFileStore(ApplicationPropertiesService propertiesService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.bucket = S3PluginFileStore.getPropertyOrThrow(PROP_BUCKET, propertiesService);
        Region region = Region.of((String)S3PluginFileStore.getPropertyOrThrow(PROP_REGION, propertiesService));
        String accessKey = S3PluginFileStore.getPropertyOrThrow(PROP_ACCESS_KEY, propertiesService);
        String secretKey = S3PluginFileStore.getPropertyOrThrow(PROP_SECRET_KEY, propertiesService);
        try {
            StaticCredentialsProvider awsCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
            S3ClientBuilder clientBuilder = (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(region)).credentialsProvider((AwsCredentialsProvider)awsCredentialsProvider);
            S3PluginFileStore.maybeApplyEndpointOverride(clientBuilder, propertiesService);
            this.s3Client = (S3Client)clientBuilder.build();
            S3Presigner.Builder presignerBuilder = S3Presigner.builder().region(region).credentialsProvider((AwsCredentialsProvider)awsCredentialsProvider);
            S3PluginFileStore.maybeApplyEndpointOverride(presignerBuilder, propertiesService);
            this.s3Presigner = presignerBuilder.build();
        }
        catch (Exception e) {
            throw new FileStoreConfigurationException("Error instantiating S3 object store", (Throwable)e);
        }
    }

    public long deleteFiles(@Nonnull DeleteFilesRequest request) {
        Objects.requireNonNull(request, "request");
        List<ObjectIdentifier> objIds = request.getDelete().stream().map(key -> (ObjectIdentifier)ObjectIdentifier.builder().key(this.filePathToKey(request.getNamespace(), (FilePath)key)).build()).toList();
        DeleteObjectsRequest deleteObjectsRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucket).delete((Delete)Delete.builder().objects(objIds).quiet(Boolean.valueOf(true)).build()).build();
        DeleteObjectsResponse deleteObjectsResponse = this.s3Client.deleteObjects(deleteObjectsRequest);
        if (deleteObjectsResponse.hasErrors()) {
            deleteObjectsResponse.errors().forEach(e -> log.error("Error deleting S3 file store object: {}", (Object)e.message()));
            throw new FileStoreException(this.i18nService.createKeyedMessage("bitbucket.filestore.s3.delete.error", new Object[0]));
        }
        return deleteObjectsResponse.deleted().size();
    }

    public long deleteRecursive(@Nonnull DeleteRecursiveRequest request) {
        Objects.requireNonNull(request, "request");
        long deletedCount = 0L;
        for (FilePath path : request.getDelete()) {
            Object prefix = this.filePathToKey(request.getNamespace(), path);
            if (!((String)prefix).endsWith("/")) {
                prefix = (String)prefix + "/";
            }
            ListObjectsV2Request listObjectsRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket).prefix((String)prefix).build();
            while (listObjectsRequest != null) {
                ListObjectsV2Response listObjectsResponse = this.s3Client.listObjectsV2(listObjectsRequest);
                if (listObjectsResponse.hasContents()) {
                    Object finalPrefix = prefix;
                    List objectsToDelete = listObjectsResponse.contents().stream().map(S3Object::key).filter(arg_0 -> S3PluginFileStore.lambda$deleteRecursive$2((String)finalPrefix, arg_0)).map(key -> (ObjectIdentifier)ObjectIdentifier.builder().key(key).build()).collect(Collectors.toList());
                    DeleteObjectsRequest deleteObjectsRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucket).delete((Delete)Delete.builder().objects(objectsToDelete).quiet(Boolean.valueOf(true)).build()).build();
                    DeleteObjectsResponse deleteObjectsResponse = this.s3Client.deleteObjects(deleteObjectsRequest);
                    if (deleteObjectsResponse.hasErrors()) {
                        deleteObjectsResponse.errors().forEach(error -> log.error("Error deleting S3 file store object: {}", (Object)error.message()));
                    }
                    deletedCount += (long)deleteObjectsResponse.deleted().size();
                }
                if (listObjectsResponse.nextContinuationToken() != null) {
                    listObjectsRequest = (ListObjectsV2Request)listObjectsRequest.toBuilder().continuationToken(listObjectsResponse.nextContinuationToken()).build();
                    continue;
                }
                listObjectsRequest = null;
            }
        }
        return deletedCount;
    }

    public boolean fileExists(@Nonnull FileExistsRequest request) {
        HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(this.filePathToKey(request.getNamespace(), request.getPath())).build();
        try {
            this.s3Client.headObject(headObjectRequest);
        }
        catch (NoSuchKeyException ignored) {
            return false;
        }
        return true;
    }

    @Nonnull
    public GenerateGetUrlResponse generateGetUrl(@Nonnull GenerateGetUrlRequest request) {
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(this.filePathToKey(request.getNamespace(), request.getPath())).responseContentType(request.getResponseContentType()).responseContentDisposition(request.getResponseContentDisposition()).build();
        GetObjectPresignRequest getObjectPresignRequest = GetObjectPresignRequest.builder().signatureDuration(request.getExpiry()).getObjectRequest(getObjectRequest).build();
        return new GenerateGetUrlResponse.Builder(this.s3Presigner.presignGetObject(getObjectPresignRequest).url()).build();
    }

    @Nonnull
    public GeneratePutUrlResponse generatePutUrl(@Nonnull GeneratePutUrlRequest request) {
        PutObjectRequest.Builder putObjectRequestBuilder = PutObjectRequest.builder().bucket(this.bucket).key(this.filePathToKey(request.getNamespace(), request.getPath()));
        ChecksumAlgorithm algorithm = request.getChecksumAlgorithm();
        if (algorithm == ChecksumAlgorithm.SHA256) {
            putObjectRequestBuilder.checksumAlgorithm(software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.SHA256);
            putObjectRequestBuilder.checksumSHA256(request.getChecksum());
        } else if (algorithm != null) {
            throw new FileStoreException(this.i18nService.createKeyedMessage("bitbucket.filestore.s3.checksum-algorithm.unsupported", new Object[]{request.getChecksumAlgorithm()}));
        }
        PutObjectPresignRequest putObjectPresignRequest = PutObjectPresignRequest.builder().signatureDuration(request.getExpiry()).putObjectRequest((PutObjectRequest)putObjectRequestBuilder.build()).build();
        PresignedPutObjectRequest presignedPutObjectRequest = this.s3Presigner.presignPutObject(putObjectPresignRequest);
        return new GeneratePutUrlResponse.Builder(presignedPutObjectRequest.url()).header(presignedPutObjectRequest.signedHeaders()).build();
    }

    @Nonnull
    public Optional<Long> getFreeSpace() {
        return Optional.empty();
    }

    @Nonnull
    public InputStream readFile(@Nonnull ReadFileRequest request) {
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(this.filePathToKey(request.getNamespace(), request.getPath())).build();
        return this.s3Client.getObject(getObjectRequest);
    }

    private String filePathToKey(@Nonnull String namespace, @Nonnull FilePath path) {
        return namespace + "/" + path.getPath();
    }

    private static String getPropertyOrThrow(String key, ApplicationPropertiesService propertiesService) {
        String value = propertiesService.getPluginProperty(key);
        if (value == null) {
            throw new FileStoreConfigurationException("Required configuration property not found: " + key);
        }
        return value;
    }

    private static void maybeApplyEndpointOverride(S3ClientBuilder clientBuilder, ApplicationPropertiesService propertiesService) {
        String endpointOverride = propertiesService.getPluginProperty(PROP_ENDPOINT_OVERRIDE);
        if (endpointOverride != null) {
            try {
                clientBuilder.endpointOverride(new URI(endpointOverride));
                clientBuilder.forcePathStyle(Boolean.valueOf(true));
            }
            catch (URISyntaxException e) {
                throw new FileStoreConfigurationException("Invalid endpoint override URI", (Throwable)e);
            }
        }
    }

    private static void maybeApplyEndpointOverride(S3Presigner.Builder s3PresignerBuilder, ApplicationPropertiesService propertiesService) {
        String endpointOverride = propertiesService.getPluginProperty(PROP_ENDPOINT_OVERRIDE);
        if (endpointOverride != null) {
            try {
                s3PresignerBuilder.endpointOverride(new URI(endpointOverride));
                S3Configuration configuration = (S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build();
                s3PresignerBuilder.serviceConfiguration(configuration);
            }
            catch (URISyntaxException e) {
                throw new FileStoreConfigurationException("Invalid endpoint override URI", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ boolean lambda$deleteRecursive$2(String finalPrefix, String key) {
        return key.startsWith(finalPrefix);
    }
}

