/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.sync;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.sync.RefSyncAction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RefSyncRequest {
    private final RefSyncAction action;
    private final Map<String, Object> context;
    private final String refId;
    private final Repository repository;

    private RefSyncRequest(Repository repository, String refId, RefSyncAction action, Map<String, Object> context) {
        this.action = action;
        this.context = context;
        this.repository = repository;
        this.refId = refId;
    }

    @Nonnull
    public RefSyncAction getAction() {
        return this.action;
    }

    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Nonnull
    public String getRefId() {
        return this.refId;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Object> context = ImmutableMap.builder();
        private RefSyncAction action;
        private String refId;
        private Repository repository;

        @Nonnull
        public RefSyncRequest build() {
            Preconditions.checkState((this.action != null ? 1 : 0) != 0, (Object)"The synchronization action to perform is required");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.refId), (Object)"The ref to synchronize is required");
            Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)"The repository containing the ref to be synchronized is required");
            return new RefSyncRequest(this.repository, this.refId, this.action, (Map<String, Object>)this.context.build());
        }

        @Nonnull
        public Builder action(@Nonnull RefSyncAction value) {
            this.action = Objects.requireNonNull(value, "action");
            return this;
        }

        @Nonnull
        public Builder context(@Nonnull String key, @Nonnull Object value) {
            this.context.put((Object)key, value);
            return this;
        }

        @Nonnull
        public Builder context(@Nonnull Map<String, Object> value) {
            this.context.putAll(value);
            return this;
        }

        @Nonnull
        public Builder refId(@Nonnull String value) {
            Objects.requireNonNull(value, "refId");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"The provided refId is blank");
            this.refId = value;
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull Repository value) {
            this.repository = Objects.requireNonNull(value, "repository");
            return this;
        }
    }
}

