/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.bitbucket.search.SearchDistribution;
import com.atlassian.bitbucket.search.SearchInformationService;
import com.atlassian.bitbucket.util.Version;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="searchInformationService")
public class DefaultSearchInformationService
implements SearchInformationService {
    private final SearchClient searchClient;

    public DefaultSearchInformationService(SearchClient searchClient) {
        this.searchClient = searchClient;
    }

    @Nonnull
    public Optional<SearchDistribution> getDistribution() {
        return this.getVersionResponse().map(SearchVersion::getDistribution);
    }

    @Nonnull
    public Optional<Version> getVersion() {
        return this.getVersionResponse().map(SearchVersion::getVersion);
    }

    private Optional<SearchVersion> getVersionResponse() {
        return Observables.consumeSingle(this.searchClient.getVersion()).toOptional();
    }
}

