/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.client;

import com.atlassian.bitbucket.internal.search.client.ConfigurableSearchClient;
import com.atlassian.bitbucket.internal.search.client.SearchClientNotConfiguredException;
import com.atlassian.bitbucket.internal.search.client.VersionCachingSearchClient;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.bitbucket.internal.search.version.SearchVersionUtils;
import com.atlassian.elasticsearch.client.Client;
import com.atlassian.elasticsearch.client.request.RequestBuilder;
import com.atlassian.elasticsearch.client.request.Response;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import rx.Observable;

public class DefaultConfigurableSearchClient
implements ConfigurableSearchClient,
VersionCachingSearchClient {
    private volatile Optional<Client> client = Optional.empty();
    private volatile Observable<SearchVersion> version;

    @Override
    public void clearVersionCache() {
        this.version = null;
    }

    @Override
    public void close() {
        this.client.ifPresent(Client::close);
        this.clearVersionCache();
    }

    @Override
    @Nonnull
    public <T extends Response> Observable<T> defer(@Nonnull RequestBuilder<T> request) {
        return Observable.defer(() -> this.execute(request));
    }

    @Override
    @Nonnull
    public <T extends Response> Observable<T> execute(@Nonnull RequestBuilder<T> request) {
        return this.client.map(client -> Observable.from((Future)client.execute(request))).orElseGet(() -> Observable.error((Throwable)new SearchClientNotConfiguredException()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Observable<SearchVersion> getVersion() {
        if (this.version == null) {
            DefaultConfigurableSearchClient defaultConfigurableSearchClient = this;
            synchronized (defaultConfigurableSearchClient) {
                if (this.version == null) {
                    this.version = SearchVersionUtils.getVersion(this).doOnError(throwable -> this.clearVersionCache()).cache().single();
                }
            }
        }
        return this.version;
    }

    @Override
    public Observable<Boolean> isVersionCacheStale() {
        if (this.version == null) {
            return Observable.just((Object)false);
        }
        return SearchVersionUtils.getVersion(this).zipWith(this.version, (version1, version2) -> !Objects.equals(version1, version2)).onErrorReturn(throwable -> true);
    }

    @Override
    public synchronized void replaceClient(@Nonnull Client client) {
        Optional<Client> oldClient = this.client;
        this.client = Optional.of(Objects.requireNonNull(client, "client"));
        oldClient.ifPresent(Client::close);
        this.clearVersionCache();
    }
}

