/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.clientutil;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.regions.Region;

public class AwsRequestSigningInterceptor
implements HttpRequestInterceptor {
    private static final String AWS_SERVICE = "es";
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region region;
    private final String service;
    private final HttpSigner<AwsCredentialsIdentity> signer;

    public AwsRequestSigningInterceptor(@Nonnull String region) {
        this(AWS_SERVICE, (HttpSigner<AwsCredentialsIdentity>)AwsV4HttpSigner.create(), (AwsCredentialsProvider)DefaultCredentialsProvider.create(), region);
    }

    @VisibleForTesting
    AwsRequestSigningInterceptor(@Nonnull String service, @Nonnull HttpSigner<AwsCredentialsIdentity> signer, @Nonnull AwsCredentialsProvider awsCredentialsProvider, @Nonnull String region) {
        this.service = Objects.requireNonNull(service, "service");
        this.signer = Objects.requireNonNull(signer, "signer");
        this.awsCredentialsProvider = Objects.requireNonNull(awsCredentialsProvider, "awsCredentialsProvider");
        this.region = Region.of((String)Objects.requireNonNull(region, "region"));
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        SdkHttpFullRequest sdkRequest = this.buildSdkHttpRequest(request, context);
        SignedRequest signedRequest = this.signer.sign(req -> ((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)req.identity((Identity)this.awsCredentialsProvider.resolveCredentials())).request((SdkHttpRequest)sdkRequest)).payload((Object)sdkRequest.contentStreamProvider().orElse(null))).putProperty(AwsV4FamilyHttpSigner.SERVICE_SIGNING_NAME, (Object)this.service)).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)this.region.id()));
        request.setHeaders(AwsRequestSigningInterceptor.repackHeaders(signedRequest.request().headers()));
    }

    private SdkHttpFullRequest buildSdkHttpRequest(HttpRequest request, HttpContext context) throws IOException {
        HttpEntityEnclosingRequest httpEntityEnclosingRequest;
        URI requestUri = AwsRequestSigningInterceptor.buildUri(context, request.getRequestLine().getUri());
        SdkHttpFullRequest.Builder requestBuilder = SdkHttpFullRequest.builder().method(SdkHttpMethod.fromValue((String)request.getRequestLine().getMethod())).uri(requestUri);
        if (request instanceof HttpEntityEnclosingRequest && (httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            httpEntityEnclosingRequest.getEntity().writeTo((OutputStream)outputStream);
            byte[] contentBytes = outputStream.toByteArray();
            if (!httpEntityEnclosingRequest.getEntity().isRepeatable()) {
                BasicHttpEntity entity = new BasicHttpEntity();
                entity.setContent((InputStream)new ByteArrayInputStream(contentBytes));
                httpEntityEnclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)entity));
            }
            requestBuilder.contentStreamProvider(() -> new ByteArrayInputStream(contentBytes));
        }
        Map<String, List<String>> headers = AwsRequestSigningInterceptor.requestHeadersToMap(request.getAllHeaders());
        headers.put("x-amz-content-sha256", Collections.singletonList("required"));
        requestBuilder.headers(headers);
        return requestBuilder.build();
    }

    private static URI buildUri(HttpContext context, String uri) throws IOException {
        try {
            URIBuilder builder = new URIBuilder(uri);
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            if (host != null) {
                builder.setHost(host.getHostName());
                builder.setPort(host.getPort());
                builder.setScheme(host.getSchemeName());
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static boolean ignoreHeader(Header header) {
        return "content-length".equalsIgnoreCase(header.getName()) && "0".equals(header.getValue()) || "host".equalsIgnoreCase(header.getName());
    }

    private static Header[] repackHeaders(Map<String, List<String>> headers) {
        return (Header[])headers.entrySet().stream().flatMap(header -> ((List)header.getValue()).stream().map(value -> new BasicHeader((String)header.getKey(), value))).toArray(Header[]::new);
    }

    private static Map<String, List<String>> requestHeadersToMap(Header ... headers) {
        return Arrays.stream(headers).filter(header -> !AwsRequestSigningInterceptor.ignoreHeader(header)).collect(Collectors.groupingBy(NameValuePair::getName, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER), Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
    }
}

