/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.clientutil;

import com.atlassian.bitbucket.internal.search.common.clientutil.AwsRequestSigningInterceptor;
import com.atlassian.bitbucket.internal.search.common.clientutil.SearchClientFactory;
import com.atlassian.bitbucket.internal.search.common.clientutil.SearchClientSettings;
import com.atlassian.bitbucket.internal.search.common.settings.SearchSettingsAccessor;
import com.atlassian.bitbucket.internal.search.common.settings.UsernamePassword;
import com.atlassian.elasticsearch.client.Client;
import com.atlassian.elasticsearch.client.apache.httpclient.ApacheRequestExecutor;
import com.atlassian.elasticsearch.client.apache.httpclient.Credentials;
import com.atlassian.elasticsearch.client.apache.httpclient.HttpClientConfiguration;
import com.atlassian.elasticsearch.client.apache.httpclient.UsernamePasswordCredentials;
import com.atlassian.elasticsearch.client.content.JsonParser;
import com.atlassian.elasticsearch.client.content.JsonRenderer;
import com.atlassian.elasticsearch.client.gson.GsonParser;
import com.atlassian.elasticsearch.client.gson.GsonRenderer;
import com.atlassian.elasticsearch.client.request.RequestExecutor;
import com.codahale.metrics.MetricRegistry;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Optional;
import org.apache.http.HttpRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="searchClientFactory")
public class DefaultSearchClientFactory
implements SearchClientFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultSearchClientFactory.class);

    @Override
    @Nonnull
    public Client create(@Nonnull SearchClientSettings settings, @Nonnull MetricRegistry metricRegistry) {
        String serverUrl = settings.getBaseUrl();
        log.debug("Create new search client using server URL '{}'", (Object)serverUrl);
        HttpClientConfiguration.Builder builder = HttpClientConfiguration.builder().keepAliveIdleTimeout(settings.getHttpKeepAliveIdleTimeout()).connectionRequestTimeout(settings.getHttpConnectionPoolTimeout()).connectionTimeout(settings.getHttpConnectionTimeout()).socketTimeout(settings.getHttpSocketTimeout()).maxConnections(settings.getMaxPoolConnections()).maxConnectionsPerRoute(settings.getMaxPoolConnections());
        return this.createDefaultClientBuilder(settings.getBaseUrl(), settings.getAwsRegion(), settings.getUsernamePassword(), builder, Optional.of(metricRegistry));
    }

    @Override
    @Nonnull
    public Client create(@Nonnull SearchSettingsAccessor searchSettings) {
        String searchUrl = searchSettings.getBaseUrl();
        log.debug("Create new inspecting search client using server URL '{}'", (Object)searchUrl);
        HttpClientConfiguration.Builder builder = HttpClientConfiguration.builder().connectionRequestTimeout(Duration.ofSeconds(1L)).connectionTimeout(Duration.ofSeconds(5L)).socketTimeout(Duration.ofSeconds(5L));
        return this.createDefaultClientBuilder(searchUrl, searchSettings.getAwsRegion(), searchSettings.getUsernamePassword(), builder, Optional.empty());
    }

    private Client createDefaultClientBuilder(String serverUrl, Optional<String> awsRegion, Optional<UsernamePassword> usernamePassword, HttpClientConfiguration.Builder template, Optional<MetricRegistry> metricRegistry) {
        usernamePassword.ifPresent(credentials -> template.credentials((Credentials)new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword())));
        awsRegion.ifPresent(region -> {
            template.customConfigurer(clientBuilder -> clientBuilder.addInterceptorLast((HttpRequestInterceptor)new AwsRequestSigningInterceptor((String)region)));
            log.debug("Configured AWS request signing for region '{}'", region);
        });
        return Client.builder().serverUrl(serverUrl).jsonParser((JsonParser)new GsonParser()).jsonRenderer((JsonRenderer)new GsonRenderer()).requestExecutor((RequestExecutor)new ApacheRequestExecutor(template.build(), (MetricRegistry)metricRegistry.orElse(null))).build();
    }
}

