/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.cluster;

import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobState;
import com.atlassian.cache.Cache;
import com.google.common.base.Enums;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="clusterJobGuardian")
public class ClusterJobGuardian {
    public static final String JOB_GUARDIAN_CACHE_NAME = "com.atlassian.bitbucket.search.job.cache";
    private final Cache<String, String> jobStateCache;

    @Autowired
    public ClusterJobGuardian(@Qualifier(value="com.atlassian.bitbucket.search.job.cache") Cache<String, String> jobStateCache) {
        this.jobStateCache = jobStateCache;
    }

    public ClusterJobState getState(String jobKey) {
        return this.getNullSafeJobState((String)this.jobStateCache.get((Object)jobKey));
    }

    public void resetJob(String jobKey) {
        this.jobStateCache.put((Object)jobKey, (Object)ClusterJobState.PENDING.name());
    }

    public boolean takeJob(String jobKey) {
        String previousValue = (String)this.jobStateCache.putIfAbsent((Object)jobKey, (Object)ClusterJobState.TAKEN.name());
        return previousValue == null || this.jobStateCache.replace((Object)jobKey, (Object)ClusterJobState.PENDING.name(), (Object)ClusterJobState.TAKEN.name());
    }

    private ClusterJobState getNullSafeJobState(String value) {
        return value == null ? ClusterJobState.PENDING : (ClusterJobState)((Object)Enums.getIfPresent(ClusterJobState.class, (String)value).or((Object)ClusterJobState.PENDING));
    }
}

