/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.cluster;

import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobGuardian;
import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobScheduler;
import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobState;
import com.atlassian.bitbucket.internal.search.common.cluster.Job;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterJobRunner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(ClusterJobRunner.class);
    private final ClusterJobGuardian clusterJobGuardian;
    private final ClusterJobScheduler clusterJobScheduler;
    private final Job job;

    public ClusterJobRunner(@Nonnull ClusterJobScheduler clusterJobScheduler, @Nonnull ClusterJobGuardian clusterJobGuardian, @Nonnull Job job) {
        this.clusterJobGuardian = Objects.requireNonNull(clusterJobGuardian, "clusterJobGuardian");
        this.clusterJobScheduler = Objects.requireNonNull(clusterJobScheduler, "clusterJobScheduler");
        this.job = Objects.requireNonNull(job, "job");
    }

    public Class<? extends Job> getJobClass() {
        return this.job.getClass();
    }

    public JobRunnerKey getKey() {
        return JobRunnerKey.of((String)this.job.getClass().getName());
    }

    public boolean isStartupJob() {
        return this.job.isStartupJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JobRunnerResponse runJob(@Nullable JobRunnerRequest jobRunnerRequest) {
        Objects.requireNonNull(jobRunnerRequest, "jobRunnerRequest");
        if (jobRunnerRequest.isCancellationRequested()) {
            log.info("Job has been canceled.  Job key: {}  Job id: {}", (Object)this.key(jobRunnerRequest), (Object)this.id(jobRunnerRequest));
            return JobRunnerResponse.success();
        }
        boolean hasJobOwnership = this.clusterJobGuardian.takeJob(this.key(jobRunnerRequest));
        if (!hasJobOwnership) {
            if (this.clusterJobGuardian.getState(this.key(jobRunnerRequest)) == ClusterJobState.PENDING) {
                log.warn("Unable to take the job, but no other node has taken it, either. Rescheduling. Job key: {}  Job id: {}", (Object)this.key(jobRunnerRequest), (Object)this.id(jobRunnerRequest));
                this.clusterJobScheduler.rescheduleFailedJob(jobRunnerRequest, this.job.getRetryPolicy());
            } else {
                log.debug("Job is already taken, no action is required. Job key: {}", (Object)this.key(jobRunnerRequest));
            }
        } else {
            log.debug("Job has started: {}", (Object)jobRunnerRequest.getJobId());
            boolean jobSuccessful = false;
            try {
                jobSuccessful = this.job.run();
            }
            finally {
                if (!jobSuccessful) {
                    this.clusterJobGuardian.resetJob(this.key(jobRunnerRequest));
                    log.warn("Job execution failed. Rescheduling. Job key: {}  Job id: {}", (Object)this.key(jobRunnerRequest), (Object)this.id(jobRunnerRequest));
                    this.clusterJobScheduler.rescheduleFailedJob(jobRunnerRequest, this.job.getRetryPolicy());
                } else if (!this.job.isStartupJob()) {
                    this.clusterJobGuardian.resetJob(this.key(jobRunnerRequest));
                }
            }
        }
        return JobRunnerResponse.success();
    }

    private JobId id(JobRunnerRequest jobRunnerRequest) {
        return jobRunnerRequest.getJobId();
    }

    private String key(JobRunnerRequest jobRunnerRequest) {
        return jobRunnerRequest.getJobConfig().getJobRunnerKey().toString();
    }
}

