/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.cluster;

import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobRunner;
import com.atlassian.bitbucket.internal.search.common.cluster.RetryPolicy;
import com.atlassian.bitbucket.util.RetryBackoffUtils;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusterJobScheduler {
    static final Duration INITIAL_SCHEDULE_DELAY = Duration.ofSeconds(15L);
    private static final int JOB_MAX_RETRY_COUNT = 10;
    private static final String JOB_RETRY_COUNT = "retries";
    private static final Map<String, Serializable> DEFAULT_PARAMETERS = ImmutableMap.of((Object)"retries", (Object)0);
    private static final Duration MAX_SCHEDULE_DELAY = Duration.ofMinutes(10L);
    private static final Duration MIN_SCHEDULE_DELAY = Duration.ofMinutes(1L);
    private static final Logger log = LoggerFactory.getLogger(ClusterJobScheduler.class);
    private final Clock clock;
    private final SchedulerService schedulerService;

    @Autowired
    public ClusterJobScheduler(@Nonnull SchedulerService schedulerService, @Nonnull Clock clock) {
        this.schedulerService = Objects.requireNonNull(schedulerService, "schedulerService");
        this.clock = Objects.requireNonNull(clock, "clock");
    }

    public void rescheduleFailedJob(JobRunnerRequest jobRunnerRequest, RetryPolicy retryPolicy) {
        JobConfig config = jobRunnerRequest.getJobConfig();
        int retryCount = (Integer)config.getParameters().get(JOB_RETRY_COUNT) + 1;
        if (retryCount > 10 && retryPolicy == RetryPolicy.DEFAULT) {
            log.error("Job has been rescheduled {} times, but has been unable to complete successfully. Job will not be rescheduled, operator intervention is required. Job key: {}", (Object)10, (Object)config.getJobRunnerKey());
            return;
        }
        retryPolicy.logFailure(log, retryCount, 10);
        Date when = Date.from(this.clock.instant().plus(ClusterJobScheduler.getBackOffDelay(retryCount)));
        JobConfig jobConfig = config.withSchedule(Schedule.runOnce((Date)when)).withParameters((Map)ImmutableMap.of((Object)JOB_RETRY_COUNT, (Object)retryCount));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Unable to reschedule the job. Job key: {}", (Object)config.getJobRunnerKey(), (Object)e);
        }
    }

    public boolean scheduleJob(ClusterJobRunner jobRunner, Instant when) {
        JobRunnerKey jobKey = jobRunner.getKey();
        this.schedulerService.registerJobRunner(jobKey, (JobRunner)jobRunner);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobKey).withParameters(DEFAULT_PARAMETERS).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce((Date)Date.from(when)));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            return true;
        }
        catch (SchedulerServiceException e) {
            log.error("Unable to schedule the job. Job key: {}", (Object)jobKey, (Object)e);
            return false;
        }
    }

    public boolean scheduleJob(ClusterJobRunner jobRunner) {
        return this.scheduleJob(jobRunner, this.clock.instant().plus(INITIAL_SCHEDULE_DELAY));
    }

    public void unscheduleJob(JobRunnerKey jobRunnerKey) {
        this.schedulerService.getJobsByJobRunnerKey(jobRunnerKey).forEach(jobId -> {
            log.debug("Attempting to unschedule job with Job Runner Key: {} and Job ID: {}. Note: This will only affect jobs that are pending and not yet running.", (Object)jobRunnerKey, (Object)jobId.getJobId());
            this.schedulerService.unscheduleJob(jobId.getJobId());
        });
        this.schedulerService.unregisterJobRunner(jobRunnerKey);
    }

    public void unscheduleJob(ClusterJobRunner jobRunner) {
        this.unscheduleJob(jobRunner.getKey());
    }

    private static Duration getBackOffDelay(int retryCount) {
        return RetryBackoffUtils.calculateDelay((int)retryCount, (Duration)MIN_SCHEDULE_DELAY, (Duration)MAX_SCHEDULE_DELAY);
    }
}

