/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.cluster;

import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobGuardian;
import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobManager;
import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobRunner;
import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobScheduler;
import com.atlassian.bitbucket.internal.search.common.cluster.Job;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="clusterJobManager")
public class DefaultClusterJobManager
implements LifecycleAware,
ClusterJobManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterJobManager.class);
    private final ClusterJobGuardian clusterJobGuardian;
    private final ClusterJobScheduler clusterJobScheduler;
    private List<ClusterJobRunner> clusterJobRunners;

    @Autowired
    public DefaultClusterJobManager(ClusterJobGuardian clusterJobGuardian, ClusterJobScheduler clusterJobScheduler) {
        this.clusterJobGuardian = clusterJobGuardian;
        this.clusterJobScheduler = clusterJobScheduler;
        this.clusterJobRunners = Collections.synchronizedList(new ArrayList());
    }

    public void onStart() {
    }

    public void onStop() {
        this.clusterJobRunners.forEach(this.clusterJobScheduler::unscheduleJob);
    }

    @Override
    public void registerJob(Job job) {
        log.info("Registering job for " + job.getClass().getSimpleName());
        ClusterJobRunner clusterJobRunner = new ClusterJobRunner(this.clusterJobScheduler, this.clusterJobGuardian, job);
        this.clusterJobRunners.add(clusterJobRunner);
        if (clusterJobRunner.isStartupJob()) {
            this.clusterJobScheduler.scheduleJob(clusterJobRunner);
        }
    }

    @Override
    public void removeAllJobsOfType(Class<? extends Job> job) {
        this.unscheduleAdHocJob(job);
        this.clusterJobRunners.removeIf(runner -> runner.getJobClass().isAssignableFrom(job));
    }

    @Override
    public boolean scheduleAdHocJob(Instant when, Class<? extends Job> jobClass) {
        log.info("Attempting to schedule an ad-hoc for " + jobClass.getSimpleName());
        log.info("There are currently " + this.clusterJobRunners.size() + " to select from");
        return this.clusterJobRunners.stream().filter(job -> jobClass.isAssignableFrom(job.getJobClass())).anyMatch(job -> this.clusterJobScheduler.scheduleJob((ClusterJobRunner)job, when));
    }

    @Override
    public void unscheduleAdHocJob(Class<? extends Job> jobClass) {
        this.clusterJobRunners.stream().filter(job -> jobClass.isAssignableFrom(job.getJobClass())).forEach(this.clusterJobScheduler::unscheduleJob);
    }
}

