/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.mapping;

import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryContextDefinition;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SimpleRepositoryContextDefinition
implements RepositoryContextDefinition {
    private final boolean isArchived;
    private final boolean isFork;
    private final boolean isPublic;
    private final int projectId;
    private final int repositoryId;

    private SimpleRepositoryContextDefinition(Builder builder) {
        this.isArchived = builder.isArchived;
        this.isFork = builder.isFork;
        this.isPublic = builder.isPublic;
        this.projectId = builder.projectId;
        this.repositoryId = builder.repositoryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleRepositoryContextDefinition)) {
            return false;
        }
        SimpleRepositoryContextDefinition that = (SimpleRepositoryContextDefinition)o;
        return this.isArchived == that.isArchived && this.isPublic == that.isPublic && this.isFork == that.isFork && this.projectId == that.projectId && this.repositoryId == that.repositoryId;
    }

    @Override
    public int getProjectId() {
        return this.projectId;
    }

    @Override
    public int getRepositoryId() {
        return this.repositoryId;
    }

    public int hashCode() {
        return Objects.hash(this.isPublic, this.isFork, this.projectId, this.repositoryId);
    }

    @Override
    public boolean isArchived() {
        return this.isArchived;
    }

    @Override
    public boolean isFork() {
        return this.isFork;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    public String toString() {
        return "SimpleRepositoryContextDefinition{isArchived=" + this.isArchived + ", isFork=" + this.isFork + ", isPublic=" + this.isPublic + ", projectId=" + this.projectId + ", repositoryId=" + this.repositoryId + "}";
    }

    public static final class Builder {
        private boolean isArchived;
        private boolean isFork;
        private boolean isPublic;
        private int projectId;
        private int repositoryId;

        private Builder() {
        }

        private Builder(RepositoryContextDefinition context) {
            this.isArchived = context.isArchived();
            this.isPublic = context.isPublic();
            this.isFork = context.isFork();
            this.projectId = context.getProjectId();
            this.repositoryId = context.getRepositoryId();
        }

        @Nonnull
        public RepositoryContextDefinition build() {
            return new SimpleRepositoryContextDefinition(this);
        }

        public Builder isArchived(boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public Builder isFork(boolean isFork) {
            this.isFork = isFork;
            return this;
        }

        @Nonnull
        public Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        @Nonnull
        public Builder projectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        @Nonnull
        public Builder repositoryId(int repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }
    }
}

