/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings;

import com.atlassian.bitbucket.dmz.secrets.DmzSecretService;
import com.atlassian.bitbucket.dmz.secrets.SecretNamespace;
import com.atlassian.bitbucket.dmz.secrets.SecretServiceConfig;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.search.common.settings.ConfigurationLocation;
import com.atlassian.bitbucket.internal.search.common.settings.InternalSearchSettingsService;
import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.atlassian.bitbucket.internal.search.common.settings.PluginSettingsProvider;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationChangePublisher;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationChangedMessage;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationProperty;
import com.atlassian.bitbucket.internal.search.common.settings.SearchServerConfiguration;
import com.atlassian.bitbucket.internal.search.common.settings.SimpleSearchConfigurationProperty;
import com.atlassian.bitbucket.internal.search.common.settings.SimpleSearchServerConfiguration;
import com.atlassian.bitbucket.internal.search.common.settings.SimpleSearchSettings;
import com.atlassian.bitbucket.internal.search.common.settings.UsernamePassword;
import com.atlassian.bitbucket.internal.search.common.settings.ValidationError;
import com.atlassian.bitbucket.internal.search.common.settings.audit.SearchConfigurationChangeAuditEvent;
import com.atlassian.bitbucket.internal.search.common.settings.tester.SearchConnectionResult;
import com.atlassian.bitbucket.internal.search.common.settings.tester.SearchConnectionTester;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.secrets.api.SecretServiceException;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"migrateSearchPasswordUpgradeTask"})
@Service(value="searchSettingsService")
public class DefaultSearchSettingsService
implements InternalSearchSettingsService {
    protected static final String SEARCH_DEFAULT_BASE_URL = "http://localhost:7992/";
    private static final String MSG_PREFIX = "bitbucket.search.admin.serversettings.form.";
    private static final String MSG_ERR_PREFIX = "bitbucket.search.admin.serversettings.form.error.";
    private static final String ERR_BASE_URL_ABSENT = "bitbucket.search.admin.serversettings.form.error.nobaseurl";
    private static final String ERR_BASE_URL_MALFORMED = "bitbucket.search.admin.serversettings.form.error.baseurl.malformed";
    private static final String ERR_SEARCH_INACCESSIBLE = "bitbucket.search.admin.serversettings.form.error.search.inaccessible";
    private static final String ERR_PROPERTY_CONFIGURED_IN_PROPERTIES_FILE = "bitbucket.search.admin.serversettings.form.error.configuredinpropertiesfile";
    private static final String ERR_USERNAME_PASSWORD_INCONSISTENT = "bitbucket.search.admin.serversettings.form.error.usernameandpassword.inconsistent";
    private static final String ERR_RESPONSE_NOT_RECOGNIZED = "bitbucket.search.admin.serversettings.form.error.responsenotrecognized";
    private static final String ERR_CONNECTION = "bitbucket.search.admin.serversettings.form.error.connection";
    private static final String ERR_AUTHENTICATION = "bitbucket.search.admin.serversettings.form.error.authentication";
    private static final String ERR_AWS_KEYCHAIN = "bitbucket.search.admin.serversettings.form.error.awskeychain";
    private static final String ERR_UNSUPPORTED_VERSION = "bitbucket.search.admin.serversettings.form.error.unsupportedVersion";
    private static final Logger log = LoggerFactory.getLogger(DefaultSearchSettingsService.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final SearchConfigurationChangePublisher configurationChangePublisher;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final PluginSettings pluginSettings;
    private final SearchConnectionTester searchConnectionTester;
    private final DmzSecretService secretService;
    private final SecretServiceConfig secretServiceConfig;

    @Autowired
    public DefaultSearchSettingsService(ApplicationPropertiesService applicationPropertiesService, SearchConnectionTester searchConnectionTester, I18nService i18nService, PluginSettingsProvider pluginSettingsProvider, SearchConfigurationChangePublisher configurationChangePublisher, EventPublisher eventPublisher, DmzSecretService secretService, SecretServiceConfig secretServiceConfig, PermissionValidationService permissionValidationService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.searchConnectionTester = searchConnectionTester;
        this.i18nService = i18nService;
        this.eventPublisher = eventPublisher;
        this.permissionValidationService = permissionValidationService;
        this.pluginSettings = pluginSettingsProvider.getPluginSettings();
        this.configurationChangePublisher = configurationChangePublisher;
        this.secretService = secretService;
        this.secretServiceConfig = secretServiceConfig;
    }

    @Override
    @Nonnull
    public Optional<String> getAwsRegion() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        return this.getPluginProperty(PluginProperty.AWS_REGION).getValue();
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        return this.getPluginProperty(PluginProperty.BASE_URL).getValue().get();
    }

    @Override
    @Nonnull
    public SearchServerConfiguration getConfiguration(boolean isPasswordRedacted) {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        SimpleSearchServerConfiguration.Builder builder = new SimpleSearchServerConfiguration.Builder().property(this.getPluginProperty(PluginProperty.BASE_URL)).property(this.getPluginProperty(PluginProperty.AWS_REGION)).property(this.getPluginProperty(PluginProperty.USERNAME));
        SearchConfigurationProperty password = this.getPluginProperty(PluginProperty.PASSWORD);
        if (password.getValue().isPresent()) {
            if (isPasswordRedacted) {
                builder.property(new SimpleSearchConfigurationProperty(PluginProperty.PASSWORD, null, password.getConfiguredAt().orElse(null)));
            } else {
                builder.property(password);
            }
        } else {
            builder.property(new SimpleSearchConfigurationProperty(PluginProperty.PASSWORD, null, null));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Optional<String> getPluginPropertyValue(@Nonnull PluginProperty property) {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        return this.getPluginProperty(property).getValue();
    }

    @Override
    @Nonnull
    public Optional<UsernamePassword> getUsernamePassword() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        return this.getPluginProperty(PluginProperty.USERNAME).getValue().flatMap(username -> this.getPluginProperty(PluginProperty.PASSWORD).getValue().map(password -> UsernamePassword.of(username, password)));
    }

    @Override
    public void updateConnectionSettings(@Nullable String baseUrl, @Nullable String awsRegion, @Nullable String username, @Nullable String password) {
        if (this.validateConnectionSettings(baseUrl, awsRegion, username, password).isEmpty()) {
            HashMap<PluginProperty, Pair<String, String>> changes = new HashMap<PluginProperty, Pair<String, String>>();
            this.maybeSaveSetting(PluginProperty.BASE_URL, baseUrl, changes);
            this.maybeSaveSetting(PluginProperty.AWS_REGION, awsRegion, changes);
            this.maybeSaveSetting(PluginProperty.USERNAME, username, changes);
            this.maybeSaveSetting(PluginProperty.PASSWORD, password, changes);
            if (!changes.keySet().isEmpty()) {
                this.eventPublisher.publish((Object)new SearchConfigurationChangeAuditEvent(this, changes));
                this.configurationChangePublisher.publish(new SearchConfigurationChangedMessage(new ArrayList<PluginProperty>(changes.keySet())));
            }
        }
    }

    @Override
    @Nonnull
    public List<ValidationError> validateAndTestConnectionSettings(@Nullable String baseUrl, @Nullable String awsRegion, @Nullable String username, @Nullable String password) {
        List<ValidationError> validationErrors = this.validateConnectionSettings(baseUrl, awsRegion, username, password);
        if (validationErrors.isEmpty()) {
            SimpleSearchSettings.Builder settingsBuilder = new SimpleSearchSettings.Builder(baseUrl);
            if (awsRegion != null) {
                settingsBuilder.awsRegion(awsRegion);
            }
            if (username != null && password != null) {
                settingsBuilder.usernameAndPassword(UsernamePassword.of(username, password));
            }
            SearchConnectionResult connectionResult = this.searchConnectionTester.testConnection(settingsBuilder.build());
            this.validateConnectionResult(validationErrors, connectionResult);
        }
        return validationErrors;
    }

    @Override
    @Nonnull
    public List<ValidationError> validateConnectionSettings(@Nullable String baseUrl, @Nullable String awsRegion, @Nullable String username, @Nullable String password) {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        this.isPropertyEditabilityViolated(PluginProperty.BASE_URL, baseUrl).ifPresent(validationErrors::add);
        this.isPropertyEditabilityViolated(PluginProperty.AWS_REGION, awsRegion).ifPresent(validationErrors::add);
        this.isPropertyEditabilityViolated(PluginProperty.USERNAME, username).ifPresent(validationErrors::add);
        this.isPropertyEditabilityViolated(PluginProperty.PASSWORD, password).ifPresent(validationErrors::add);
        if (validationErrors.isEmpty()) {
            this.validateBaseUrl(baseUrl).ifPresent(validationErrors::add);
            this.validateUsernamePassword(username, password).ifPresent(validationErrors::add);
        }
        return validationErrors;
    }

    @VisibleForTesting
    SearchConfigurationProperty getPluginProperty(@Nonnull PluginProperty property) {
        Optional<String> value = this.getPropertyFromFile(property);
        if (value.isPresent()) {
            return new SimpleSearchConfigurationProperty(property, value.orElse(null), ConfigurationLocation.PROPERTIES);
        }
        value = Optional.ofNullable((String)this.pluginSettings.get(property.getSettingKey())).filter(innerValue -> !"{ATL_SECURED}".equals(innerValue));
        if (value.isPresent()) {
            return new SimpleSearchConfigurationProperty(property, value.orElse(null), ConfigurationLocation.DATABASE);
        }
        if (property.isSecret() && !this.secretServiceConfig.isDisabled()) {
            try {
                String secretValue = this.secretService.get(SecretNamespace.INTERNAL, property.getSettingKey()).orElse(null);
                return new SimpleSearchConfigurationProperty(property, secretValue, ConfigurationLocation.DATABASE);
            }
            catch (SecretServiceException e) {
                log.error("Failed to get property {} from secure storage", (Object)property, (Object)e);
                return new SimpleSearchConfigurationProperty(property, null, null);
            }
        }
        if (property == PluginProperty.BASE_URL) {
            return new SimpleSearchConfigurationProperty(PluginProperty.BASE_URL, SEARCH_DEFAULT_BASE_URL, null);
        }
        return new SimpleSearchConfigurationProperty(property, null, null);
    }

    private Optional<String> getPropertyFromFile(PluginProperty property) {
        String value = this.applicationPropertiesService.getPluginProperty(property.getPropertyKey());
        if ("".equals(value)) {
            log.warn("Empty value for '{}' property is defined in application properties file", (Object)property);
        }
        return Optional.ofNullable(value);
    }

    private Optional<ValidationError> isPropertyEditabilityViolated(PluginProperty property, String value) {
        String pluginProperty = this.getPluginProperty(property).getValue().orElse(null);
        if (this.isPropertyEditable(property) || Objects.equals(pluginProperty, value)) {
            return Optional.empty();
        }
        return Optional.of(ValidationError.propertyError(property, this.i18nService.getMessage(ERR_PROPERTY_CONFIGURED_IN_PROPERTIES_FILE, new Object[]{this.i18nService.getMessage(String.format("%s%s.label", MSG_PREFIX, property.getId()), new Object[0])})));
    }

    private boolean isPropertyEditable(@Nonnull PluginProperty property) {
        return this.getPropertyFromFile(property).isEmpty();
    }

    private void maybeSaveSetting(PluginProperty pluginProperty, String newValue, Map<PluginProperty, Pair<String, String>> changes) {
        String oldValue = this.getPluginProperty(pluginProperty).getValue().orElse(null);
        if (this.savePluginSetting(pluginProperty, newValue, oldValue)) {
            changes.put(pluginProperty, (Pair<String, String>)Pair.of((Object)oldValue, (Object)newValue));
        }
    }

    private boolean savePluginSetting(PluginProperty property, String newValue, String oldValue) {
        if (!Objects.equals(oldValue, newValue) && this.isPropertyEditable(property)) {
            if (property.isSecret() && !this.secretServiceConfig.isDisabled()) {
                if (newValue != null) {
                    this.secretService.put(SecretNamespace.INTERNAL, property.getSettingKey(), newValue);
                    this.pluginSettings.put(property.getSettingKey(), (Object)"{ATL_SECURED}");
                } else {
                    this.secretService.delete(SecretNamespace.INTERNAL, property.getSettingKey());
                    this.pluginSettings.put(property.getSettingKey(), null);
                }
            } else {
                this.pluginSettings.put(property.getSettingKey(), (Object)newValue);
            }
            return true;
        }
        return false;
    }

    private Optional<ValidationError> validateBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            return Optional.of(ValidationError.propertyError(PluginProperty.BASE_URL, this.i18nService.getMessage(ERR_BASE_URL_ABSENT, new Object[0])));
        }
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            return Optional.of(ValidationError.propertyError(PluginProperty.BASE_URL, this.i18nService.getMessage(ERR_BASE_URL_MALFORMED, new Object[0])));
        }
        return Optional.empty();
    }

    private void validateConnectionResult(List<ValidationError> validationErrors, SearchConnectionResult connectionResult) {
        switch (connectionResult) {
            case SUCCESS: {
                break;
            }
            case APPLICATION_ERROR: {
                validationErrors.add(ValidationError.propertyError(PluginProperty.BASE_URL, this.i18nService.getMessage(ERR_RESPONSE_NOT_RECOGNIZED, new Object[0])));
                break;
            }
            case AUTHENTICATION_ERROR: {
                validationErrors.add(ValidationError.generalError(this.i18nService.getMessage(ERR_AUTHENTICATION, new Object[0])));
                break;
            }
            case AWS_KEYCHAIN_ERROR: {
                validationErrors.add(ValidationError.generalError(this.i18nService.getMessage(ERR_AWS_KEYCHAIN, new Object[0])));
                break;
            }
            case CONNECTION_ERROR: {
                validationErrors.add(ValidationError.generalError(this.i18nService.getMessage(ERR_CONNECTION, new Object[0])));
                break;
            }
            case UNSUPPORTED_VERSION: {
                validationErrors.add(ValidationError.generalError(this.i18nService.getMessage(ERR_UNSUPPORTED_VERSION, new Object[0])));
                break;
            }
            default: {
                validationErrors.add(ValidationError.generalError(this.i18nService.getMessage(ERR_SEARCH_INACCESSIBLE, new Object[0])));
            }
        }
    }

    private Optional<ValidationError> validateUsernamePassword(String username, String password) {
        boolean usernameEditable = this.isPropertyEditable(PluginProperty.USERNAME);
        boolean passwordEditable = this.isPropertyEditable(PluginProperty.PASSWORD);
        if (!usernameEditable && !passwordEditable) {
            return Optional.empty();
        }
        if (!usernameEditable) {
            username = this.getPropertyFromFile(PluginProperty.USERNAME).orElse(null);
        }
        if (!passwordEditable) {
            password = this.getPropertyFromFile(PluginProperty.PASSWORD).orElse(null);
        }
        if (username == null && password == null || username != null && password != null) {
            return Optional.empty();
        }
        PluginProperty invalidProperty = usernameEditable && passwordEditable ? (username == null ? PluginProperty.USERNAME : PluginProperty.PASSWORD) : (usernameEditable ? PluginProperty.USERNAME : PluginProperty.PASSWORD);
        return Optional.of(ValidationError.propertyError(invalidProperty, this.i18nService.getMessage(ERR_USERNAME_PASSWORD_INCONSISTENT, new Object[0])));
    }
}

