/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings;

public enum PluginProperty {
    AWS_REGION("aws.region", "awsRegion"),
    BASE_URL("baseurl", "searchBaseUrl"),
    USERNAME("username", "searchUsername"),
    PASSWORD("password", "searchPassword", true);

    private final String fieldKey;
    private final String id;
    private final boolean secret;

    private PluginProperty(String id, String fieldKey) {
        this(id, fieldKey, false);
    }

    private PluginProperty(String id, String fieldKey, boolean secret) {
        this.fieldKey = fieldKey;
        this.id = id;
        this.secret = secret;
    }

    public String getChangedFlagKey() {
        return this.fieldKey + "Changed";
    }

    public String getEditableFlagKey() {
        return this.fieldKey + "Editable";
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getHasValueFlagKey() {
        return this.fieldKey + "Set";
    }

    public String getId() {
        return this.id;
    }

    public String getPropertyKey() {
        return "plugin.search.config." + this.id;
    }

    public String getSettingKey() {
        return "elasticsearch." + this.id;
    }

    public boolean isSecret() {
        return this.secret;
    }
}

