/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings;

import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationChangedMessage;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchConfigurationChangePublisher {
    private static final Logger log = LoggerFactory.getLogger(SearchConfigurationChangePublisher.class);
    private final TopicService topicService;

    @Autowired
    public SearchConfigurationChangePublisher(TopicService topicService) {
        this.topicService = topicService;
    }

    public void publish(SearchConfigurationChangedMessage message) {
        log.debug("Sending event notification about a search server URL change to all nodes");
        this.topicService.getTopic(message.getTopic(), TopicSettings.builder(SearchConfigurationChangedMessage.class).build()).publish((Serializable)message);
    }
}

