/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings;

import com.atlassian.bitbucket.internal.search.common.settings.InternalSearchSettingsService;
import com.atlassian.bitbucket.internal.search.common.settings.InvalidConfigurationException;
import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationRequest;
import com.atlassian.bitbucket.internal.search.common.settings.SearchServerConfiguration;
import com.atlassian.bitbucket.internal.search.common.settings.ValidationError;
import com.atlassian.bitbucket.util.ValueWrapper;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="searchConfigurationManager")
public class SearchConfigurationManager {
    private final InternalSearchSettingsService searchSettingsService;

    @Autowired
    public SearchConfigurationManager(InternalSearchSettingsService searchSettingsService) {
        this.searchSettingsService = searchSettingsService;
    }

    @Nonnull
    public SearchServerConfiguration getCurrentConfiguration() {
        return this.searchSettingsService.getConfiguration(true);
    }

    @Nonnull
    public SearchServerConfiguration updateConfiguration(@Nonnull SearchConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        ConfigurationData configData = this.extractConfigurationData(request);
        List<ValidationError> validationErrors = this.searchSettingsService.validateConnectionSettings(configData.baseUrl, configData.awsRegion, configData.username, configData.password);
        if (!validationErrors.isEmpty()) {
            throw new InvalidConfigurationException(validationErrors);
        }
        this.searchSettingsService.updateConnectionSettings(configData.baseUrl, configData.awsRegion, configData.username, configData.password);
        return this.searchSettingsService.getConfiguration(true);
    }

    public void validateConfiguration(@Nonnull SearchConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        ConfigurationData configData = this.extractConfigurationData(request);
        List<ValidationError> validationErrors = this.searchSettingsService.validateAndTestConnectionSettings(configData.baseUrl, configData.awsRegion, configData.username, configData.password);
        if (!validationErrors.isEmpty()) {
            throw new InvalidConfigurationException(validationErrors);
        }
    }

    public void validateSavedConfiguration() {
        SearchServerConfiguration currentConfiguration = this.searchSettingsService.getConfiguration(false);
        List<ValidationError> validationErrors = this.searchSettingsService.validateAndTestConnectionSettings(currentConfiguration.getBaseUrl().getValue().orElse(null), currentConfiguration.getAwsRegion().getValue().orElse(null), currentConfiguration.getUsername().getValue().orElse(null), currentConfiguration.getPassword().getValue().orElse(null));
        if (!validationErrors.isEmpty()) {
            throw new InvalidConfigurationException(validationErrors);
        }
    }

    private ConfigurationData extractConfigurationData(SearchConfigurationRequest request) {
        Map<PluginProperty, ValueWrapper<String>> updates = request.getUpdates();
        String baseUrl = this.getUpdatedValue(updates, PluginProperty.BASE_URL);
        String awsRegion = this.getUpdatedValue(updates, PluginProperty.AWS_REGION);
        String username = this.getUpdatedValue(updates, PluginProperty.USERNAME);
        String password = this.getUpdatedValue(updates, PluginProperty.PASSWORD);
        return new ConfigurationData(baseUrl, awsRegion, username, password);
    }

    private String getUpdatedValue(Map<PluginProperty, ValueWrapper<String>> updates, PluginProperty property) {
        return updates.get((Object)property) != null ? (String)((Object)updates.get((Object)property).get()) : (String)this.searchSettingsService.getPluginPropertyValue(property).orElse(null);
    }

    private record ConfigurationData(String baseUrl, String awsRegion, String username, String password) {
    }
}

