/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings;

import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.atlassian.bitbucket.util.ValueWrapper;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class SearchConfigurationRequest {
    private final Map<PluginProperty, ValueWrapper<String>> updates;

    public SearchConfigurationRequest(Builder builder) {
        this.updates = builder.updates.build();
    }

    public Map<PluginProperty, ValueWrapper<String>> getUpdates() {
        return this.updates;
    }

    public static class Builder {
        private final ImmutableMap.Builder<PluginProperty, ValueWrapper<String>> updates = ImmutableMap.builder();

        @Nonnull
        public SearchConfigurationRequest build() {
            return new SearchConfigurationRequest(this);
        }

        @Nonnull
        public Builder update(@Nonnull PluginProperty property, @Nullable String value) {
            this.updates.put((Object)Objects.requireNonNull(property, "property"), (Object)new ValueWrapper((Serializable)((Object)value)));
            return this;
        }
    }
}

