/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings;

import com.atlassian.bitbucket.internal.search.common.settings.ConfigurationLocation;
import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class SimpleSearchConfigurationProperty
implements SearchConfigurationProperty {
    public static final String CONFIGURED_AT = "configuredAt";
    public static final String VALUE = "value";
    private final ConfigurationLocation configuredAt;
    private final PluginProperty property;
    private final String value;

    public SimpleSearchConfigurationProperty(@Nonnull PluginProperty property, @Nullable String value, @Nullable ConfigurationLocation configuredAt) {
        this.configuredAt = configuredAt;
        this.property = Objects.requireNonNull(property, "pluginProperty");
        this.value = value;
    }

    @Override
    @Nonnull
    public Optional<ConfigurationLocation> getConfiguredAt() {
        return Optional.ofNullable(this.configuredAt);
    }

    @Override
    @Nonnull
    public PluginProperty getProperty() {
        return this.property;
    }

    @Override
    @Nonnull
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }
}

