/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings;

import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationProperty;
import com.atlassian.bitbucket.internal.search.common.settings.SearchServerConfiguration;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public final class SimpleSearchServerConfiguration
implements SearchServerConfiguration {
    private final SearchConfigurationProperty awsRegion;
    private final SearchConfigurationProperty baseUrl;
    private final SearchConfigurationProperty password;
    private final SearchConfigurationProperty username;

    private SimpleSearchServerConfiguration(Builder builder) {
        ImmutableMap properties = builder.properties.build();
        this.awsRegion = Objects.requireNonNull((SearchConfigurationProperty)properties.get((Object)PluginProperty.AWS_REGION), "awsRegion");
        this.baseUrl = Objects.requireNonNull((SearchConfigurationProperty)properties.get((Object)PluginProperty.BASE_URL), "baseUrl");
        this.password = Objects.requireNonNull((SearchConfigurationProperty)properties.get((Object)PluginProperty.PASSWORD), "password");
        this.username = Objects.requireNonNull((SearchConfigurationProperty)properties.get((Object)PluginProperty.USERNAME), "username");
    }

    @Override
    @Nonnull
    public SearchConfigurationProperty getAwsRegion() {
        return this.awsRegion;
    }

    @Override
    @Nonnull
    public SearchConfigurationProperty getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Nonnull
    public SearchConfigurationProperty getPassword() {
        return this.password;
    }

    @Override
    @Nonnull
    public SearchConfigurationProperty getUsername() {
        return this.username;
    }

    public static class Builder {
        private final ImmutableMap.Builder<PluginProperty, SearchConfigurationProperty> properties = ImmutableMap.builder();

        @Nonnull
        public SimpleSearchServerConfiguration build() {
            return new SimpleSearchServerConfiguration(this);
        }

        public Builder property(@Nonnull SearchConfigurationProperty value) {
            Objects.requireNonNull(value, "value");
            this.properties.put((Object)value.getProperty(), (Object)value);
            return this;
        }
    }
}

