/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings;

import com.atlassian.bitbucket.internal.search.common.settings.SearchSettingsAccessor;
import com.atlassian.bitbucket.internal.search.common.settings.UsernamePassword;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class SimpleSearchSettings
implements SearchSettingsAccessor {
    private final String awsRegion;
    private final String baseUrl;
    private final UsernamePassword usernamePassword;

    private SimpleSearchSettings(Builder builder) {
        this.awsRegion = builder.awsRegion;
        this.baseUrl = builder.baseUrl;
        this.usernamePassword = builder.usernameAndPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSearchSettings that = (SimpleSearchSettings)o;
        return Objects.equals(this.awsRegion, that.awsRegion) && Objects.equals(this.baseUrl, that.baseUrl) && Objects.equals(this.usernamePassword, that.usernamePassword);
    }

    @Override
    @Nonnull
    public Optional<String> getAwsRegion() {
        return Optional.ofNullable(this.awsRegion);
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Nonnull
    public Optional<UsernamePassword> getUsernamePassword() {
        return Optional.ofNullable(this.usernamePassword);
    }

    public int hashCode() {
        int result = this.awsRegion.hashCode();
        result = 31 * result + this.baseUrl.hashCode();
        result = 31 * result + this.usernamePassword.hashCode();
        return result;
    }

    public static class Builder {
        private final String baseUrl;
        private String awsRegion;
        private UsernamePassword usernameAndPassword;

        public Builder(@Nonnull String value) {
            this.baseUrl = Objects.requireNonNull(value, "baseUrl");
        }

        public Builder awsRegion(@Nonnull String value) {
            this.awsRegion = Objects.requireNonNull(value, "awsRegion");
            return this;
        }

        public SimpleSearchSettings build() {
            return new SimpleSearchSettings(this);
        }

        public Builder usernameAndPassword(@Nonnull UsernamePassword value) {
            this.usernameAndPassword = Objects.requireNonNull(value, "usernameAnePassword");
            return this;
        }
    }
}

