/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings;

import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class ValidationError {
    @JsonProperty
    private final String errorMessage;
    @JsonProperty
    private final PluginProperty property;

    private ValidationError(@Nullable PluginProperty property, @Nonnull String errorMessage) {
        this.property = property;
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage");
    }

    public static ValidationError generalError(@Nonnull String errorMessage) {
        return new ValidationError(null, errorMessage);
    }

    public static ValidationError propertyError(@Nonnull PluginProperty property, @Nonnull String errorMessage) {
        return new ValidationError(Objects.requireNonNull(property, "property"), errorMessage);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Optional<PluginProperty> getProperty() {
        return Optional.ofNullable(this.property);
    }

    public String toString() {
        return "ValidationError{property=" + String.valueOf((Object)this.property) + ", errorMessage='" + this.errorMessage + "'}";
    }
}

