/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings.atst;

import com.atlassian.bitbucket.internal.search.indexing.administration.DefaultIndexConfigurationService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.BrokenRepositoryService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetails;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;

public class BrokenRepositoriesSupportData
extends RootLevelSupportDataAppender {
    private static final String SEARCH = "Search";
    private final BrokenRepositoryService brokenRepositoryService;

    public BrokenRepositoriesSupportData(BrokenRepositoryService brokenRepositoryService) {
        this.brokenRepositoryService = brokenRepositoryService;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        SupportDataBuilder categoryBuilder = supportDataBuilder.addCategory(SEARCH);
        int brokenRepositoryCount = this.brokenRepositoryService.getBrokenRepositoryCount();
        categoryBuilder.addValue("brokenRepositoryCount", String.valueOf(brokenRepositoryCount));
        if (brokenRepositoryCount > 0) {
            this.brokenRepositoryService.getBrokenRepositoryIndexingDetails(PageUtils.newRequest((int)0, (int)DefaultIndexConfigurationService.MAX_RESULT_WINDOW)).forEach(repoDetails -> this.addRepoDetails((RepositoryIndexingDetails)repoDetails, categoryBuilder));
        }
    }

    private void addRepoDetails(RepositoryIndexingDetails repoDetails, SupportDataBuilder builder) {
        builder.addValue(repoDetails.getProjectKey() + "/" + repoDetails.getRepositorySlug(), repoDetails.toString());
    }
}

