/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings.atst;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.settings.InternalSearchSettingsService;
import com.atlassian.bitbucket.internal.search.common.settings.SimpleSearchSettings;
import com.atlassian.bitbucket.internal.search.common.settings.UsernamePassword;
import com.atlassian.bitbucket.internal.search.common.settings.tester.SearchConnectionResult;
import com.atlassian.bitbucket.internal.search.common.settings.tester.SearchConnectionTester;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.util.Optional;

public class SearchSettingsSupportData
extends RootLevelSupportDataAppender {
    private static final String SEARCH = "Search";
    private final SearchConnectionTester connectionTester;
    private final SearchClient searchClient;
    private final InternalSearchSettingsService searchSettingsService;
    private final EscalatedSecurityContext withSysAdmin;

    public SearchSettingsSupportData(SearchConnectionTester connectionTester, SearchClient searchClient, InternalSearchSettingsService searchSettingsService, SecurityService securityService) {
        this.connectionTester = connectionTester;
        this.searchClient = searchClient;
        this.searchSettingsService = searchSettingsService;
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "Search settings support data");
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        this.addConnectionDetails(supportDataBuilder);
    }

    private void addConnectionDetails(SupportDataBuilder supportDataBuilder) {
        SupportDataBuilder searchBuilder = supportDataBuilder.addCategory(SEARCH);
        SimpleSearchSettings searchSettings = (SimpleSearchSettings)this.withSysAdmin.call(() -> {
            String baseUrl = this.searchSettingsService.getBaseUrl();
            searchBuilder.addValue("base-url", baseUrl);
            Optional<String> maybeAwsRegion = this.searchSettingsService.getAwsRegion();
            Optional<UsernamePassword> maybeUsernamePassword = this.searchSettingsService.getUsernamePassword();
            SimpleSearchSettings.Builder settingsBuilder = new SimpleSearchSettings.Builder(baseUrl);
            maybeAwsRegion.ifPresent(awsRegion -> {
                settingsBuilder.awsRegion((String)awsRegion);
                searchBuilder.addValue("aws-region", awsRegion);
            });
            maybeUsernamePassword.ifPresent(usernamePassword -> {
                settingsBuilder.usernameAndPassword((UsernamePassword)usernamePassword);
                searchBuilder.addValue("username", usernamePassword.getUsername());
                searchBuilder.addValue("hasPassword", Boolean.toString(!usernamePassword.getPassword().isEmpty()));
            });
            return settingsBuilder.build();
        });
        SearchConnectionResult searchConnectionResult = this.connectionTester.testConnection(searchSettings);
        searchBuilder.addValue("connection-result", searchConnectionResult.name());
        SearchVersion version = (SearchVersion)Observables.consumeSingle(this.searchClient.getVersion()).getOrNull();
        if (version != null) {
            searchBuilder.addValue("distribution", version.getDistribution().getName());
            searchBuilder.addValue("version", version.getVersion().toString());
        }
    }
}

