/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings.audit;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.atlassian.bitbucket.internal.search.common.settings.audit.SearchConfigurationChangeAuditEvent;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class SearchConfigurationAuditEventConverter
implements AuditEventConverter<SearchConfigurationChangeAuditEvent> {
    @VisibleForTesting
    static final String KEY_BASE_URL = "bitbucket.search.audit.changedvalue.searchconfigurationchange.baseurl";
    @VisibleForTesting
    static final String KEY_USERNAME = "bitbucket.search.audit.changedvalue.searchconfigurationchange.username";

    @Nonnull
    public AuditEvent convert(@Nonnull SearchConfigurationChangeAuditEvent event, @Nonnull AuditEvent.Builder builder) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(builder, "builder");
        Map<PluginProperty, Pair<String, String>> changedProperties = event.getChangedProperties();
        if (changedProperties.containsKey((Object)PluginProperty.BASE_URL)) {
            Pair<String, String> changedBaseUrl = changedProperties.get((Object)PluginProperty.BASE_URL);
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_BASE_URL).from((String)changedBaseUrl.getLeft()).to((String)changedBaseUrl.getRight()).build());
        }
        if (changedProperties.containsKey((Object)PluginProperty.USERNAME)) {
            Pair<String, String> changedUsername = changedProperties.get((Object)PluginProperty.USERNAME);
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_USERNAME).from((String)changedUsername.getLeft()).to((String)changedUsername.getRight()).build());
        }
        return builder.build();
    }
}

