/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationManager;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationRequest;
import com.atlassian.bitbucket.internal.search.common.settings.SearchServerConfiguration;
import com.atlassian.bitbucket.internal.search.common.settings.rest.entity.RestSearchServerConfigurationRequest;
import com.atlassian.bitbucket.internal.search.common.settings.rest.entity.RestSearchServerConfigurationResponse;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/configuration")
@Tag(name="Search")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Singleton
@SystemAdminOnly
@WebSudoRequired
public class SearchConfigurationResource {
    private final SearchConfigurationManager searchConfigurationManager;

    @Inject
    public SearchConfigurationResource(SearchConfigurationManager searchConfigurationManager) {
        this.searchConfigurationManager = searchConfigurationManager;
    }

    @Operation(description="Retrieve the current settings used to authenticate to the external search server instance.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission or higher to call this resource.", summary="Get search server authentication settings")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The search server configuration setting", representation=RestSearchServerConfigurationResponse.class), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified project.", responseCode=401, restError=true)})
    @Path(value="/")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getConfiguration() {
        SearchServerConfiguration configuration = this.searchConfigurationManager.getCurrentConfiguration();
        return Response.ok().entity((Object)new RestSearchServerConfigurationResponse(configuration)).build();
    }

    @Operation(description="Returns the status of the connection to an external search server instance using the currently configuration.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission or higher to call this resource.", summary="Get status of connection to search server")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Connection to the search server was successful."), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified project.", responseCode=401, restError=true)})
    @Path(value="/status")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getConnectionStatus() {
        this.searchConfigurationManager.validateSavedConfiguration();
        return Response.noContent().build();
    }

    @Operation(description="Update the settings used to authenticate to the external search server instance and return the updated configuration.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission or higher to call this resource.", summary="Update search server authentication settings")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The updated search server configuration setting", representation=RestSearchServerConfigurationRequest.class), @ResponseDoc(responseCode=400, documentation="The requested search server configuration is invalid.", restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified project.", responseCode=401, restError=true)})
    @Path(value="/")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setConfiguration(RestSearchServerConfigurationRequest request) {
        SearchConfigurationRequest updateRequest = SearchConfigurationResource.convertRequest(request);
        SearchServerConfiguration updatedConfiguration = this.searchConfigurationManager.updateConfiguration(updateRequest);
        return Response.ok().entity((Object)new RestSearchServerConfigurationResponse(updatedConfiguration)).build();
    }

    @Operation(description="Returns the status of the connection to an external search server instance using the settings provided in the request body.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission or higher to call this resource.", summary="Get status of connection to search server with new settings")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Connection to the search server was successful."), @ResponseDoc(responseCode=400, documentation="Connection to the search server failed.", restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified project.", responseCode=401, restError=true)})
    @Path(value="/test")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response testConfiguration(RestSearchServerConfigurationRequest request) {
        SearchConfigurationRequest testRequest = SearchConfigurationResource.convertRequest(request);
        this.searchConfigurationManager.validateConfiguration(testRequest);
        return Response.noContent().build();
    }

    private static SearchConfigurationRequest convertRequest(RestSearchServerConfigurationRequest request) {
        SearchConfigurationRequest.Builder converted = new SearchConfigurationRequest.Builder();
        if (request.hasBaseUrl()) {
            converted.update(PluginProperty.BASE_URL, request.getBaseUrl());
        }
        if (request.hasAwsRegion()) {
            converted.update(PluginProperty.AWS_REGION, request.getAwsRegion());
        }
        if (request.hasUsername()) {
            converted.update(PluginProperty.USERNAME, request.getUsername());
        }
        if (request.hasPassword()) {
            converted.update(PluginProperty.PASSWORD, request.getPassword());
        }
        return converted.build();
    }
}

