/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings.rest.entity;

import com.atlassian.bitbucket.internal.search.common.settings.ConfigurationLocation;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationProperty;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.Map;

@JsonSerialize
public class RestConfigurableProperty
extends RestMapEntity {
    public static final String CONFIGURED_AT = "configuredAt";
    public static final String VALUE = "value";

    public RestConfigurableProperty(SearchConfigurationProperty setting) {
        this.put(CONFIGURED_AT, setting.getConfiguredAt().orElse(null));
        this.put(VALUE, setting.getValue().orElse(null));
    }

    private RestConfigurableProperty(Map<String, Object> values) {
        super(values);
    }

    public static RestConfigurableProperty valueOf(Object value) {
        if (value instanceof RestConfigurableProperty) {
            return (RestConfigurableProperty)((Object)value);
        }
        if (value instanceof Map) {
            return new RestConfigurableProperty((Map)value);
        }
        return null;
    }

    @Schema(description="The storage location of the configuration setting.\nNote that while a setting can be configured in both DATABASE and PROPERTIES, the value in PROPERTIES is used with precedence. A null value indicates that the setting has not been configured.", example="DATABASE")
    @Nullable
    public ConfigurationLocation getConfiguredAt() {
        return (ConfigurationLocation)this.getEnumProperty(CONFIGURED_AT, ConfigurationLocation.class);
    }

    @Schema(description="The value of the configuration setting. A null value indicates that the \nsetting has not been configured.", example="us-east-2")
    @Nullable
    public String getValue() {
        return this.getStringProperty(VALUE);
    }
}

