/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings.rest.entity;

import com.atlassian.bitbucket.internal.search.common.settings.rest.entity.RestSearchServerConfiguration;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@JsonSerialize
@Schema(description="Request payload for updating search server configuration. For all fields, the following behavior is observed: If the key does not exist, the property remains unchanged. If the key exists but has a null value, the property is removed. Otherwise, the property is overridden with the specified value.")
public class RestSearchServerConfigurationRequest
extends RestSearchServerConfiguration {
    @Schema(description="AWS region to use for AWS request signing", requiredMode=Schema.RequiredMode.NOT_REQUIRED, example="us-east-2")
    @Nonnull
    public String getAwsRegion() {
        return this.getStringProperty("awsRegion");
    }

    @Schema(description="The base URL of the search server", requiredMode=Schema.RequiredMode.NOT_REQUIRED, example="http://localhost:9200")
    @Nonnull
    public String getBaseUrl() {
        return this.getStringProperty("url");
    }

    @Schema(description="The password for authentication with the search server", requiredMode=Schema.RequiredMode.NOT_REQUIRED, example="mySecurePassword123")
    @Nullable
    public String getPassword() {
        return this.getStringProperty("password");
    }

    @Schema(description="The username for authentication with the search server", requiredMode=Schema.RequiredMode.NOT_REQUIRED, example="admin")
    @Nonnull
    public String getUsername() {
        return this.getStringProperty("username");
    }

    @Hidden
    public boolean hasAwsRegion() {
        return this.containsKey("awsRegion");
    }

    @Hidden
    public boolean hasBaseUrl() {
        return this.containsKey("url");
    }

    @Hidden
    public boolean hasPassword() {
        return this.containsKey("password");
    }

    @Hidden
    public boolean hasUsername() {
        return this.containsKey("username");
    }
}

